package org.jboss.testharness.impl.runner.servlet;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.jboss.testharness.api.TestResult;
import org.jboss.testharness.impl.runner.TestResultImpl;
import org.jboss.testharness.impl.runner.TestRunner;
import org.testng.ITestResult;

public class ServletTestRunner extends HttpServlet
{
   
   
  
   @Override
   protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException
   {
      TestRunner runner = new TestRunner();
      String methodName = null;
      if (req.getParameter("methodName") != null)
      {
         methodName = req.getParameter("methodName");
         runner.getMethodNames().add(methodName);
      }
      String outputMode;
      if (req.getParameter("outputMode") != null)
      {
         outputMode = (String) req.getParameter("outputMode");
      }
      else
      {
         outputMode = "html";
      }
      if (outputMode.equals("serializedObject") && methodName == null)
      {
         resp.sendError(HttpServletResponse.SC_INTERNAL_SERVER_ERROR, "No method name specified");
         return;
      }
      
      if (outputMode.equals("html"))
      {
         runner.run(false);
         resp.setContentType("text/html");
         resp.setStatus(HttpServletResponse.SC_OK);
         PrintWriter writer = resp.getWriter();
         writer.write("<html>\n");
         writer.write("<head><title>TCK Report</title></head>\n");
         writer.write("<body>\n");
         writer.write("<h2>Configuration</h2>\n");
         writer.write("<table>\n");
         writer.write("<tr>\n");
         writer.write("<td><b>Method</b></td><td><b>Status</b></td>\n");
         writer.write("</tr>\n");
         for (ITestResult result : runner.getContext().getFailedConfigurations().getAllResults())
         {
            writeResult(writer, result);
         }
         for (ITestResult result : runner.getContext().getSkippedConfigurations().getAllResults())
         {
            writeResult(writer, result);
         }
         writer.write("</table>\n");
         writer.write("<h2>Tests</h2>\n");
         writer.write("<table>\n");
         writer.write("<tr>\n");
         writer.write("<td><b>Method</b></td><td><b>Status</b></td>\n");
         writer.write("</tr>\n");
         for (ITestResult result : runner.getContext().getFailedTests().getAllResults())
         {
            writeResult(writer, result);
         }
         for (ITestResult result : runner.getContext().getPassedTests().getAllResults())
         {
            writeResult(writer, result);
         }
         for (ITestResult result : runner.getContext().getSkippedTests().getAllResults())
         {
            writeResult(writer, result);
         }
         writer.write("</table>\n");
         writer.write("</body>\n");
      }
      else if (outputMode.equals("serializedObject"))
      {
         runner.run(true);
         ObjectOutputStream oos = new ObjectOutputStream(resp.getOutputStream());
         if (runner.getTestResults().size() == 1)
         {
            TestResult result;
            if (runner.getTestResults().get(0).getStatus() == 3)
            {
               // This is a skip, so there was a configuration problem
               // send that instead
               result = TestResultImpl.of(runner.getConfigurationResults().get(0));
            }
            else
            {
               result = TestResultImpl.of(runner.getTestResults().get(0));
            }
            oos.writeObject(result);
            resp.setStatus(HttpServletResponse.SC_OK);
            oos.flush();
            oos.close();
         }
         else
         {
            resp.sendError(HttpServletResponse.SC_INTERNAL_SERVER_ERROR, ">1 result!");
         }
         
      }
      else
      {
         resp.sendError(500, "No report format specified");
      }
   }
   
   private static void writeResult(PrintWriter writer, ITestResult result)
   {
      writer.write("<tr>\n");
      writer.write("<td>" + result.getMethod() + "</td>");
      writer.write("<td>" + statusAsString(result.getStatus()) + "</td>");
      writer.write("</tr>\n");
      if (result.getStatus() == ITestResult.FAILURE)
      {
         writer.write("<tr>\n");
         writer.write("<td colspan=\"2\"><pre>");
         result.getThrowable().printStackTrace(writer);
         writer.write("</pre></td>");
         writer.write("</tr>\n");
      }
   }
   
   private static String statusAsString(int statusCode)
   {
      switch (statusCode)
      {
      case ITestResult.SUCCESS:
         return "success";
      case ITestResult.FAILURE:
         return "failure";
      case ITestResult.SKIP:
         return "skipped";
      default:
         return "unknown";
      }
   }
   
}
