/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.testharness;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Set;
import org.apache.log4j.Logger;
import org.jboss.testharness.ExpectedException;
import org.jboss.testharness.api.Configuration;
import org.jboss.testharness.api.DeploymentException;
import org.jboss.testharness.api.TestResult;
import org.jboss.testharness.impl.ConfigurationImpl;
import org.jboss.testharness.impl.packaging.ArtifactGenerator;
import org.jboss.testharness.impl.packaging.jsr299.JSR299ArtifactDescriptor;
import org.jboss.testharness.impl.packaging.jsr299.TCKArtifactDescriptor;
import org.testng.IHookCallBack;
import org.testng.IHookable;
import org.testng.ITestContext;
import org.testng.ITestResult;
import org.testng.annotations.AfterClass;
import org.testng.annotations.AfterSuite;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeSuite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTest
implements IHookable {
    private static Logger log = Logger.getLogger(AbstractTest.class);
    private static boolean inContainer = false;
    private TCKArtifactDescriptor artifact;
    private DeploymentException deploymentException;
    private boolean skipTest = false;

    public static boolean isInContainer() {
        return inContainer;
    }

    public static void setInContainer(boolean inContainer) {
        AbstractTest.inContainer = inContainer;
    }

    private boolean isSuiteDeployingTestsToContainer() {
        return !AbstractTest.isInContainer() && (!this.getCurrentConfiguration().isStandalone() || this.getCurrentConfiguration().isRunIntegrationTests());
    }

    private void generateArtifact() {
        if (!AbstractTest.isInContainer()) {
            ArtifactGenerator generator = new ArtifactGenerator(this.getCurrentConfiguration());
            this.artifact = generator.createArtifact(this.getClass());
        }
    }

    private boolean isDeployToContainerNeeded() {
        return !AbstractTest.isInContainer() && this.artifact != null && (this.getCurrentConfiguration().isStandalone() && !this.artifact.isUnit() && this.getCurrentConfiguration().isRunIntegrationTests() || !this.getCurrentConfiguration().isStandalone());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deployArtifact() {
        block15: {
            try {
                if (this.isDeployToContainerNeeded()) {
                    InputStream jar = null;
                    try {
                        jar = this.artifact.getJarAsStream();
                        this.getCurrentConfiguration().getContainers().deploy(jar, this.artifact.getDefaultName());
                        break block15;
                    }
                    finally {
                        if (jar != null) {
                            jar.close();
                        }
                    }
                }
                if (this.artifact != null && this.artifact.isUnit()) {
                    Set<Class<?>> classes = this.artifact.getClasses();
                    if (this.artifact instanceof JSR299ArtifactDescriptor) {
                        this.getCurrentConfiguration().getStandaloneContainers().deploy(classes, Arrays.asList(((JSR299ArtifactDescriptor)this.artifact).getBeansXml().getSource()));
                    } else {
                        this.getCurrentConfiguration().getStandaloneContainers().deploy(classes);
                    }
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Error connecting to the container", e);
            }
            catch (DeploymentException e) {
                this.deploymentException = e;
            }
        }
        if (this.artifact != null && this.artifact.getExpectedDeploymentException() != null) {
            if (this.deploymentException != null) {
                if (AbstractTest.isThrowablePresent(this.artifact.getExpectedDeploymentException(), this.deploymentException.getCause())) {
                    this.deploymentException = null;
                    this.skipTest = true;
                }
            } else {
                this.deploymentException = new DeploymentException((Throwable)new ExpectedException("Expected exception " + this.artifact.getExpectedDeploymentException() + " but none was thrown"));
            }
        }
    }

    private void undeployArtifact() throws Exception {
        if (this.isDeployToContainerNeeded()) {
            this.getCurrentConfiguration().getContainers().undeploy(this.artifact.getDefaultName());
        }
        if (this.getCurrentConfiguration().isStandalone() && this.artifact != null && this.artifact.isUnit()) {
            this.getCurrentConfiguration().getStandaloneContainers().undeploy();
        }
    }

    private void checkAssertionsEnabled() {
        boolean assertionsEnabled = false;
        try {
            assert (false);
        }
        catch (AssertionError error) {
            assertionsEnabled = true;
        }
        if (!assertionsEnabled) {
            throw new IllegalStateException("Assertions must be enabled!");
        }
    }

    @BeforeSuite(alwaysRun=true, groups={"scaffold"})
    public void beforeSuite(ITestContext context) throws Exception {
        if (this.isSuiteDeployingTestsToContainer()) {
            this.getCurrentConfiguration().getContainers().setup();
        }
        if (this.getCurrentConfiguration().isStandalone()) {
            this.getCurrentConfiguration().getStandaloneContainers().setup();
        }
        this.checkAssertionsEnabled();
    }

    @AfterSuite(alwaysRun=true, groups={"scaffold"})
    public void afterSuite() throws Exception {
        if (this.isSuiteDeployingTestsToContainer()) {
            this.getCurrentConfiguration().getContainers().cleanup();
        }
        if (this.getCurrentConfiguration().isStandalone()) {
            this.getCurrentConfiguration().getStandaloneContainers().cleanup();
        }
    }

    @BeforeClass(alwaysRun=true, groups={"scaffold"})
    public void beforeClass() throws Throwable {
        this.generateArtifact();
        this.deployArtifact();
    }

    @AfterClass(alwaysRun=true, groups={"scaffold"})
    public void afterClass() throws Exception {
        this.undeployArtifact();
        this.artifact = null;
        this.deploymentException = null;
        this.skipTest = false;
    }

    public void beforeMethod() {
    }

    public void afterMethod() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void run(IHookCallBack callback, ITestResult testResult) {
        if (this.artifact == null && !AbstractTest.isInContainer()) {
            log.warn((Object)("Non @Artifact-test for testcase " + testResult.getMethod()));
        }
        if (this.deploymentException != null) {
            testResult.setThrowable(this.deploymentException.getCause());
        } else {
            if (!(this.isDeployToContainerNeeded() && !this.artifact.isRunLocally() || this.skipTest)) {
                try {
                    this.beforeMethod();
                    callback.runTestMethod(testResult);
                }
                finally {
                    this.afterMethod();
                    if (!(this.getCurrentConfiguration().isStandalone() || AbstractTest.isInContainer() || this.artifact.isRunLocally())) {
                        log.warn((Object)("Running testcase locally " + testResult.getMethod()));
                    }
                }
            }
            if (!this.skipTest) {
                try {
                    TestResult result = this.getCurrentConfiguration().getInContainerTestLauncher().launchTest(testResult.getMethod().getMethod());
                    if (result.getStatus().equals((Object)TestResult.Status.FAILED) || result.getStatus().equals((Object)TestResult.Status.SKIPPED)) {
                        testResult.setThrowable(result.getThrowable());
                        testResult.setStatus(2);
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException("Error connecting to the container", e);
                }
            }
        }
    }

    protected Configuration getCurrentConfiguration() {
        return ConfigurationImpl.get();
    }

    protected String getContextPath() {
        return "http://" + this.getCurrentConfiguration().getHost() + "/" + this.getClass().getName() + "/";
    }

    protected static boolean isThrowablePresent(Class<? extends Throwable> throwableType, Throwable throwable) {
        if (throwable == null) {
            return false;
        }
        if (throwableType.isAssignableFrom(throwable.getClass())) {
            return true;
        }
        return AbstractTest.isThrowablePresent(throwableType, throwable.getCause());
    }
}

