/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.testharness.impl.packaging;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.apache.log4j.Logger;
import org.jboss.testharness.api.ResourceDescriptor;
import org.jboss.testharness.impl.ConfigurationImpl;
import org.jboss.testharness.impl.packaging.ArtifactScanner;
import org.jboss.testharness.impl.util.Files;
import org.jboss.testharness.impl.util.Reflections;
import org.jboss.testharness.impl.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArtifactDescriptor {
    private static final Logger log = Logger.getLogger(ArtifactScanner.class);
    public static final Random random = new Random(System.currentTimeMillis());
    private final Set<Class<?>> classes = new HashSet();
    private final Set<ResourceDescriptor> resources = new HashSet<ResourceDescriptor>();
    private final Set<ResourceDescriptor> libraries;
    private final Class<?> declaringClass;
    private InputStream jar;
    private File explodedJar;
    private File classesRoot;
    private File librariesRoot;

    public ArtifactDescriptor(Class<?> declaringClass) {
        this.declaringClass = declaringClass;
        this.libraries = new HashSet<ResourceDescriptor>();
    }

    public ArtifactDescriptor initialize() {
        for (String packageName : ConfigurationImpl.get().getExtraPackages()) {
            this.addPackage(packageName, false);
        }
        this.getResources().addAll(ConfigurationImpl.get().getExtraResources());
        return this;
    }

    public InputStream getJarAsStream() throws IOException {
        if (this.jar == null) {
            this.jar = new JarCreator(this.getExplodedJar()).jar();
        }
        return this.jar;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URL getJar() throws IOException {
        InputStream is = null;
        try {
            is = this.getJarAsStream();
            File file = File.createTempFile(ArtifactDescriptor.class.getCanonicalName(), ".jar");
            file.deleteOnExit();
            Files.copy(is, file);
            is.close();
            URL uRL = file.toURI().toURL();
            return uRL;
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
    }

    public File getExplodedJar() throws IOException {
        if (this.explodedJar == null) {
            this.create();
        }
        return this.explodedJar;
    }

    public void create() throws IOException {
        this.explodedJar = null;
        this.jar = null;
        File root = new File(System.getProperty("java.io.tmpdir") + "/" + this.getClass().getName() + "." + random.nextInt());
        root.mkdir();
        root.deleteOnExit();
        for (Class<?> clazz : this.classes) {
            ArtifactDescriptor.copyClass(clazz, this.getClassesRoot(root));
        }
        for (ResourceDescriptor resourceDescriptor : this.resources) {
            ArtifactDescriptor.copyResource(resourceDescriptor, root);
        }
        if (this.isLibrariesSupported()) {
            for (ResourceDescriptor resourceDescriptor : this.libraries) {
                ArtifactDescriptor.copyResource(resourceDescriptor, this.getLibraryRoot(root));
            }
        }
        this.explodedJar = root;
    }

    private static void copyClass(Class<?> clazz, File root) throws IOException {
        ArtifactDescriptor.copyClass(clazz.getName(), root);
    }

    private static void copyResource(ResourceDescriptor resourceDescriptorImpl, File root) throws IOException {
        String fileName;
        String directoryName;
        if (resourceDescriptorImpl.getName().lastIndexOf("/") > 0) {
            directoryName = resourceDescriptorImpl.getName().substring(0, resourceDescriptorImpl.getName().lastIndexOf("/"));
            fileName = resourceDescriptorImpl.getName().substring(resourceDescriptorImpl.getName().lastIndexOf("/") + 1);
        } else {
            directoryName = "";
            fileName = resourceDescriptorImpl.getName();
        }
        if (Strings.isEmpty(fileName)) {
            throw new IllegalArgumentException("Unable to determine source file name of " + resourceDescriptorImpl);
        }
        File directory = ArtifactDescriptor.makeDirectoryStructure(root, directoryName);
        File file = new File(directory, fileName);
        file.createNewFile();
        file.deleteOnExit();
        Files.copy(resourceDescriptorImpl.getSource().openStream(), file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyClass(String className, File root) throws IOException {
        InputStream clazzStream = null;
        try {
            String classFilePathName = ArtifactDescriptor.getClassFileName(className);
            String directoryName = classFilePathName.substring(0, classFilePathName.lastIndexOf("/"));
            String classFileName = classFilePathName.substring(classFilePathName.lastIndexOf("/") + 1);
            File packageDirectory = ArtifactDescriptor.makeDirectoryStructure(root, directoryName);
            File classFile = new File(packageDirectory, classFileName);
            classFile.createNewFile();
            classFile.deleteOnExit();
            clazzStream = Reflections.loadResourceAsStream(classFilePathName);
            if (clazzStream == null) {
                throw new IllegalStateException("Eror loading " + className + " (" + classFilePathName + ")");
            }
            Files.copy(clazzStream, classFile);
        }
        finally {
            if (clazzStream != null) {
                clazzStream.close();
            }
        }
    }

    private static File makeDirectoryStructure(File root, String directoryName) {
        for (String directory : directoryName.split("\\/")) {
            root = new File(root, directory);
            root.mkdir();
            root.deleteOnExit();
        }
        return root;
    }

    public void writeArtifactToDisk(String outputDirectory) throws IOException {
        this.writeArtifactToDisk(outputDirectory, this.getDefaultName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeArtifactToDisk(String outputDirectory, String fileName) throws IOException {
        OutputStream os = null;
        InputStream jar = null;
        try {
            File file = new File(outputDirectory, fileName);
            file.createNewFile();
            os = new BufferedOutputStream(new FileOutputStream(file));
            jar = this.getJarAsStream();
            Files.copy(jar, os);
        }
        finally {
            if (os != null) {
                os.close();
            }
            if (jar != null) {
                jar.close();
            }
        }
    }

    public String getDefaultName() {
        return this.declaringClass.getName() + this.getExtension();
    }

    private static String getClassFileName(String className) {
        return className.replace('.', '/') + ".class";
    }

    public Set<Class<?>> getClasses() {
        return this.classes;
    }

    public Set<ResourceDescriptor> getResources() {
        return this.resources;
    }

    public void addPackage(Package pkg) {
        this.addPackage(pkg.getName(), false);
    }

    public void addPackage(String packageName, boolean addRecursively) {
        URLPackageScanner packageScanner = new URLPackageScanner(packageName, addRecursively);
        for (String className : packageScanner.getClassNames()) {
            Class<?> clazz = Reflections.loadClass(className);
            if (clazz == null) {
                System.out.println("Class null: " + className);
            }
            this.getClasses().add(clazz);
        }
    }

    public File getClassesRoot(File archiveRoot) {
        if (this.classesRoot == null) {
            this.classesRoot = ArtifactDescriptor.makeDirectoryStructure(archiveRoot, this.getClassesRoot());
        }
        return this.classesRoot;
    }

    public String getClassesRoot() {
        return "/";
    }

    public String toString() {
        return "Declared by: " + this.declaringClass.getName() + " Classes: " + this.classes + " Resources: " + this.resources;
    }

    public Class<?> getDeclaringClass() {
        return this.declaringClass;
    }

    public String getExtension() {
        return ".jar";
    }

    public Set<ResourceDescriptor> getLibraries() {
        return this.libraries;
    }

    public File getLibraryRoot(File archiveRoot) {
        if (this.librariesRoot == null) {
            this.librariesRoot = ArtifactDescriptor.makeDirectoryStructure(archiveRoot, this.getLibrariesRoot());
        }
        return this.librariesRoot;
    }

    protected String getLibrariesRoot() {
        return "/";
    }

    public boolean isLibrariesSupported() {
        return false;
    }

    private static class JarCreator {
        private final File root;

        public JarCreator(File root) {
            this.root = root;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public InputStream jar() throws IOException {
            ByteArrayOutputStream byteArrayOutputStream = null;
            ZipOutputStream jarOutputStream = null;
            try {
                byteArrayOutputStream = new ByteArrayOutputStream();
                Manifest manifest = new Manifest();
                Attributes attributes = manifest.getMainAttributes();
                attributes.putValue("Created-By", "JSR-299 TCK Harness");
                attributes.put(Attributes.Name.MANIFEST_VERSION, "1.0");
                jarOutputStream = new JarOutputStream((OutputStream)byteArrayOutputStream, manifest);
                this.jar(this.root, (JarOutputStream)jarOutputStream);
                jarOutputStream.close();
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
                return byteArrayInputStream;
            }
            finally {
                if (jarOutputStream != null) {
                    jarOutputStream.close();
                } else if (byteArrayOutputStream != null) {
                    byteArrayOutputStream.close();
                }
            }
        }

        private void jar(File directory, JarOutputStream jarOutputStream) throws IOException {
            File[] children;
            for (File child : children = directory.listFiles()) {
                if (child.isDirectory()) {
                    this.jar(child, jarOutputStream);
                    continue;
                }
                FileInputStream fis = new FileInputStream(child);
                JarEntry jarEntry = new JarEntry(child.getPath().substring(this.root.getPath().length() + 1).replaceAll("\\" + File.separator, "/"));
                jarOutputStream.putNextEntry(jarEntry);
                Files.copy((InputStream)fis, jarOutputStream);
                fis.close();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class URLPackageScanner {
        private static final Logger log = Logger.getLogger(URLPackageScanner.class);
        private final String packageName;
        private final String packageNamePath;
        private final boolean addRecursively;
        private final Set<String> classes = new HashSet<String>();

        public URLPackageScanner(Package pkg, boolean addRecursively) {
            this(pkg.getName(), addRecursively);
        }

        public URLPackageScanner(String packageName, boolean addRecursively) {
            this.packageName = packageName;
            this.packageNamePath = packageName.replace(".", "/");
            this.addRecursively = addRecursively;
        }

        private void scanPackage() {
            try {
                HashSet<String> paths = new HashSet<String>();
                for (URL url : Reflections.loadResources(this.packageNamePath)) {
                    String urlPath = url.getFile();
                    if ((urlPath = URLDecoder.decode(urlPath, "UTF-8")).startsWith("file:")) {
                        urlPath = urlPath.substring(5);
                    }
                    if (urlPath.indexOf(33) > 0) {
                        urlPath = urlPath.substring(0, urlPath.indexOf(33));
                    }
                    paths.add(urlPath);
                }
                this.handle(paths);
            }
            catch (IOException ioe) {
                log.warn((Object)("could not read: " + this.packageName), (Throwable)ioe);
            }
        }

        private void handleArchiveByFile(File file) throws IOException {
            try {
                log.trace((Object)("archive: " + file));
                ZipFile zip = new ZipFile(file);
                Enumeration<? extends ZipEntry> entries = zip.entries();
                while (entries.hasMoreElements()) {
                    ZipEntry entry = entries.nextElement();
                    String name = entry.getName();
                    if (!name.startsWith(this.packageNamePath) || !name.endsWith(".class") || !this.addRecursively && name.substring(this.packageNamePath.length() + 1).contains("/")) continue;
                    String className = name.replace("/", ".").replace(".class", "");
                    this.classes.add(className);
                }
            }
            catch (ZipException e) {
                throw new RuntimeException("Error handling file " + file, e);
            }
        }

        private void handle(Set<String> paths) throws IOException {
            for (String urlPath : paths) {
                log.trace((Object)("scanning: " + urlPath));
                File file = new File(urlPath);
                if (file.isDirectory()) {
                    this.handle(file, this.packageName);
                    continue;
                }
                this.handleArchiveByFile(file);
            }
        }

        private void handle(File file, String packageName) {
            for (File child : file.listFiles()) {
                if (!child.isDirectory() && child.getName().endsWith(".class")) {
                    this.classes.add(packageName + "." + child.getName().substring(0, child.getName().lastIndexOf(".class")));
                    continue;
                }
                if (!child.isDirectory() || !this.addRecursively) continue;
                this.handle(child, packageName + "." + child.getName());
            }
        }

        public Set<String> getClassNames() {
            this.scanPackage();
            return this.classes;
        }
    }
}

