/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.testharness.impl.packaging;

import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.apache.log4j.Logger;
import org.jboss.testharness.impl.packaging.Artifact;
import org.jboss.testharness.impl.util.Reflections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArtifactScanner {
    private static final Logger log = Logger.getLogger(ArtifactScanner.class);
    private final String packageName;
    private final String packageNameAsPath;
    private final Class<? extends Annotation> annotationType;
    private final Set<Class<?>> classes = new HashSet();

    public ArtifactScanner(String packageName, Class<? extends Annotation> annotation) {
        this.packageName = packageName;
        this.packageNameAsPath = packageName.replace(".", "/");
        this.annotationType = annotation;
    }

    private void scan() {
        try {
            HashSet<String> paths = new HashSet<String>();
            for (URL url : Reflections.loadResources(this.packageNameAsPath)) {
                String urlPath = url.getFile();
                if ((urlPath = URLDecoder.decode(urlPath, "UTF-8")).startsWith("file:")) {
                    urlPath = urlPath.substring(5);
                }
                if (urlPath.indexOf(33) > 0) {
                    urlPath = urlPath.substring(0, urlPath.indexOf(33));
                }
                paths.add(urlPath);
            }
            this.handle(paths);
        }
        catch (IOException ioe) {
            log.warn((Object)("could not read: " + this.packageName), (Throwable)ioe);
        }
    }

    private void handle(Set<String> paths) throws IOException {
        for (String urlPath : paths) {
            log.trace((Object)("scanning: " + urlPath));
            this.handle(new File(urlPath), this.packageName.substring(0, this.packageName.lastIndexOf(".")));
        }
    }

    private void handleArchiveByFile(File file) throws IOException {
        try {
            log.trace((Object)("archive: " + file));
            ZipFile zip = new ZipFile(file);
            Enumeration<? extends ZipEntry> entries = zip.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                String name = entry.getName();
                if (!name.startsWith(this.packageNameAsPath) || !name.endsWith(".class")) continue;
                this.addClass(name.replace(".class", "").replace("/", "."));
            }
        }
        catch (ZipException e) {
            throw new RuntimeException("Error handling file " + file, e);
        }
    }

    private void handle(File file, String packageName) throws IOException {
        if (file.isDirectory()) {
            packageName = packageName + "." + file.getName();
            for (File child : file.listFiles()) {
                this.handle(child, packageName);
            }
        } else if (file.getName().endsWith(".class") && !file.getName().contains("$")) {
            this.addClass(packageName + "." + file.getName().replace(".class", ""));
        } else if (file.getName().endsWith(".jar")) {
            this.handleArchiveByFile(file);
        }
    }

    private void addClass(String className) {
        Class<?> clazz = Reflections.loadClass(className);
        if (clazz != null && clazz.isAnnotationPresent(Artifact.class)) {
            if (this.annotationType != null && clazz.isAnnotationPresent(this.annotationType)) {
                this.classes.add(clazz);
            } else {
                this.classes.add(clazz);
            }
        } else if (clazz == null) {
            log.warn((Object)("Unable to load class " + className));
        }
    }

    public Set<Class<?>> getClasses() {
        this.scan();
        return this.classes;
    }
}

