/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.testharness.impl.packaging.ear;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;
import org.jboss.testharness.api.ResourceDescriptor;
import org.jboss.testharness.impl.packaging.ResourceDescriptorImpl;
import org.jboss.testharness.impl.packaging.ear.EjbJarArtifactDescriptor;
import org.jboss.testharness.impl.packaging.jsr299.JSR299ArtifactDescriptor;
import org.jboss.testharness.impl.packaging.war.WarArtifactDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EarArtifactDescriptor
extends JSR299ArtifactDescriptor {
    private static final Logger log = Logger.getLogger(EarArtifactDescriptor.class);
    public static final String APPLICATION_XML_DESTINATION = "META-INF/application.xml";
    private final EjbJarArtifactDescriptor ejbJar;
    private final WarArtifactDescriptor war;

    public EarArtifactDescriptor(Class<?> declaringClass, String beansXmlSourceFileName, String ejbJarXml) {
        super(declaringClass, null);
        this.ejbJar = new EjbJarArtifactDescriptor(declaringClass, beansXmlSourceFileName, ejbJarXml).initialize();
        this.war = new WarArtifactDescriptor(declaringClass, null){

            protected boolean isAddBeansXml() {
                return false;
            }

            public boolean isLibrariesSupported() {
                return false;
            }
        }.initialize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EarArtifactDescriptor initialize() {
        super.initialize();
        InputStream applicationXml = null;
        try {
            applicationXml = EarArtifactDescriptor.getApplicationXml(this.getDeclaringClass());
            this.getResources().add(new ResourceDescriptorImpl(APPLICATION_XML_DESTINATION, applicationXml));
        }
        catch (IOException e) {
            log.warn((Object)"Error generating ear", (Throwable)e);
        }
        finally {
            if (applicationXml != null) {
                try {
                    applicationXml.close();
                }
                catch (IOException e1) {
                    log.error((Object)"Error generating ear", (Throwable)e1);
                }
            }
        }
        return this;
    }

    @Override
    public Set<Class<?>> getClasses() {
        return this.getEjbJar().getClasses();
    }

    public EjbJarArtifactDescriptor getEjbJar() {
        return this.ejbJar;
    }

    public WarArtifactDescriptor getWar() {
        return this.war;
    }

    @Override
    public String toString() {
        return "ear, " + super.toString();
    }

    @Override
    public String getExtension() {
        return ".ear";
    }

    @Override
    public boolean isLibrariesSupported() {
        return true;
    }

    @Override
    protected String getLibrariesRoot() {
        return "lib";
    }

    @Override
    protected boolean isAddBeansXml() {
        return false;
    }

    @Override
    public void create() throws IOException {
        for (ResourceDescriptor resource : new HashSet<ResourceDescriptor>(this.getResources())) {
            if (!resource.getName().startsWith("war")) continue;
            this.getResources().remove(resource);
            this.war.getResources().add(new ResourceDescriptorImpl(resource.getName().substring(3), resource.getSource()));
        }
        this.getResources().add(new ResourceDescriptorImpl(this.war.getDefaultName(), this.war.getJar()));
        this.getResources().add(new ResourceDescriptorImpl(this.ejbJar.getDefaultName(), this.ejbJar.getJar()));
        super.create();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static InputStream getApplicationXml(Class<?> declaringClass) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            PrintWriter writer = new PrintWriter(os);
            ((Writer)writer).write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
            ((Writer)writer).write("<application xmlns=\"http://java.sun.com/xml/ns/javaee\" \n\t\txmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" \n\t\txsi:schemaLocation=\"http://java.sun.com/xml/ns/javaee http://java.sun.com/xml/ns/javaee/application_5.xsd\" \n\t\tversion=\"5\">\n\n");
            ((Writer)writer).write("\t<display-name>JSR-99 TCK: " + declaringClass.getName() + "</display-name>\n\n");
            ((Writer)writer).write("\t<module>\n\t\t<web>\n\t\t\t<web-uri>" + declaringClass.getName() + ".war</web-uri>\n" + "\t\t\t<context-root>/" + declaringClass.getName() + "</context-root>\n" + "\t\t</web>\n" + "\t</module>\n\n");
            ((Writer)writer).write("\t<module>\n\t\t<ejb>" + declaringClass.getName() + ".jar</ejb>\n" + "\t</module>\n\n");
            ((Writer)writer).write("</application>\n");
            ((Writer)writer).flush();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(os.toByteArray());
            return byteArrayInputStream;
        }
        finally {
            os.close();
        }
    }
}

