package org.jboss.testharness.impl;

import java.util.ArrayList;
import java.util.List;

import org.jboss.testharness.api.Configuration;
import org.jboss.testharness.api.ConfigurationBuilder;
import org.jboss.testharness.api.ResourceDescriptor;
import org.jboss.testharness.api.TestLauncher;
import org.jboss.testharness.properties.PropertiesManager;
import org.jboss.testharness.spi.Containers;
import org.jboss.testharness.spi.StandaloneContainers;

public class ConfigurationImpl implements Configuration
{
   
   private static final Configuration current;
   
   static
   {
      PropertiesManager properties = new PropertiesManager();
      ConfigurationBuilder builder = properties.getInstanceValue(ConfigurationBuilder.PROPERTY_NAME, ConfigurationBuilder.class, false);
      if (builder == null)
      {
         builder = new PropertiesBasedConfigurationBuilder<ConfigurationImpl>(new ConfigurationImpl());
      }
      current = builder.init().getConfiguration();
   }
   
   public static <T extends Configuration> T get(Class<T> expectedType)
   {
      try
      {
         return expectedType.cast(current);
      }
      catch (ClassCastException e)
      {
         throw new IllegalStateException("Error loading configuration, check that you have the correct ConfigurationBuilder specified on your build classpath");
      }
      
   }
   
   public static Configuration get()
   {
      return get(Configuration.class);
   }
   
   
   private String outputDirectory;
   private boolean standalone;
   private boolean runIntegrationTests;
   private int connectTimeout;
   private String libraryDirectory;
   private TestLauncher testLauncher;
   private Containers containers;
   private StandaloneContainers standaloneContainers;
   private String host;
   private List<String> extraPackages;
   private List<ResourceDescriptor> extraResources;
   private List<String> extraDeploymentProperties;
   private String testPackage;
   
   protected ConfigurationImpl()
   {
      this.extraPackages = new ArrayList<String>();
      this.extraResources = new ArrayList<ResourceDescriptor>();
      this.extraDeploymentProperties = new ArrayList<String>();
   }
   
   public ConfigurationImpl(Configuration configuration)
   {
      this.outputDirectory = configuration.getOutputDirectory();
      this.standalone = configuration.isStandalone();
      this.runIntegrationTests = configuration.isRunIntegrationTests();
      this.connectTimeout = configuration.getConnectTimeout();
      this.libraryDirectory = configuration.getLibraryDirectory();
      this.testLauncher = configuration.getInContainerTestLauncher();
      this.containers = configuration.getContainers();
      this.standaloneContainers = configuration.getStandaloneContainers();
      this.host = configuration.getHost();
      this.extraPackages = configuration.getExtraPackages();
      this.extraResources = configuration.getExtraResources();
   }

   public String getOutputDirectory()
   {
      return outputDirectory;
   }
   
   public void setOutputDirectory(String outputDirectory)
   {
      this.outputDirectory = outputDirectory;
   }
   
   public boolean isStandalone()
   {
      return standalone;
   }
   
   public void setStandalone(boolean standalone)
   {
      this.standalone = standalone;
   }

   public int getConnectTimeout()
   {
      return connectTimeout;
   }
   
   public void setConnectTimeout(int deploymentDelay)
   {
      this.connectTimeout = deploymentDelay;
   }
   
   public String getLibraryDirectory()
   {
      return libraryDirectory;
   }
   
   public void setLibraryDirectory(String libraryDir)
   {
      this.libraryDirectory = libraryDir;
   }
   
   public TestLauncher getInContainerTestLauncher()
   {
      return testLauncher;
   }
   
   public void setInContainerTestLauncher(TestLauncher testLauncher)
   {
      this.testLauncher = testLauncher;
   }

   public Containers getContainers()
   {
      return containers;
   }

   public void setContainers(Containers containers)
   {
      this.containers = containers;
   }

   public boolean isRunIntegrationTests()
   {
      return runIntegrationTests;
   }

   public void setRunIntegrationTests(boolean runIntegrationTests)
   {
      this.runIntegrationTests = runIntegrationTests;
   }
   
   public StandaloneContainers getStandaloneContainers()
   {
      return standaloneContainers;
   }
   
   public void setStandaloneContainers(StandaloneContainers standaloneContainers)
   {
      this.standaloneContainers = standaloneContainers;
   }

   public String getHost()
   {
      return host;
   }

   public void setHost(String host)
   {
      this.host = host;
   }

   public TestLauncher getTestLauncher()
   {
      return testLauncher;
   }

   public void setTestLauncher(TestLauncher testLauncher)
   {
      this.testLauncher = testLauncher;
   }   
   
   public List<String> getExtraPackages()
   {
      return extraPackages;
   }
   
   public List<ResourceDescriptor> getExtraResources()
   {
      return extraResources;
   }
   
   public List<String> getExtraDeploymentProperties()
   {
      return extraDeploymentProperties;
   }

   public String getTestPackage()
   {
      return testPackage;
   }

   public void setTestPackage(String testPackage)
   {
      this.testPackage = testPackage;
   }

   @Override
   public String toString()
   {
      StringBuilder configuration = new StringBuilder();
      configuration.append("Test harness configuration\n");
      configuration.append("-----------------\n");
      configuration.append("\tContainers: ").append(getContainers()).append("\n");
      configuration.append("\tConnect Timeout: ").append(getConnectTimeout()).append("\n");
      configuration.append("\tHost: ").append(getHost()).append("\n");
      configuration.append("\tLibrary Directory: ").append(getLibraryDirectory()).append("\n");
      configuration.append("\tOutput Directory: ").append(getOutputDirectory()).append("\n");
      configuration.append("\tRun Integration Tests: ").append(isRunIntegrationTests()).append("\n");
      configuration.append("\tStandalone: ").append(isStandalone()).append("\n");
      configuration.append("\tTest Launcher: ").append(getTestLauncher()).append("\n");
      
      return configuration.toString();
   }
   
}
