package org.jboss.testharness.impl.packaging;

import static org.jboss.testharness.impl.util.Reflections.loadResource;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

import org.jboss.testharness.api.ResourceDescriptor;
import org.jboss.testharness.impl.util.Files;

public class ResourceDescriptorImpl implements ResourceDescriptor
{
   
   private final String name;
   private final URL source;

   public ResourceDescriptorImpl(String name, InputStream source) throws IOException
   {
      this.name = name;
      File file = File.createTempFile(ResourceDescriptorImpl.class.getName(), null);
      file.deleteOnExit();
      Files.copy(source, file);
      this.source = file.toURI().toURL(); 
   }
   
   public ResourceDescriptorImpl(String name, URL source)
   {
      this.name = name;
      this.source = source;
   }
   
   public ResourceDescriptorImpl(String name, String source)
   {
      this.name = name;
      if (name == null)
      {
         throw new IllegalArgumentException("Unable to have a null resource");
      }
      this.source = loadResource(source);
      if (this.source == null)
      {
         throw new IllegalArgumentException("Unable to load file for " + source);
      }
   }
   
   /* (non-Javadoc)
    * @see org.jboss.testharness.impl.packaging.ResourceDescriptor#getName()
    */
   public String getName()
   {
      return name;
   }
   
   /* (non-Javadoc)
    * @see org.jboss.testharness.impl.packaging.ResourceDescriptor#getSource()
    */
   public URL getSource()
   {
      return source;
   }
   
   @Override
   public boolean equals(Object obj)
   {
      if (obj instanceof ResourceDescriptorImpl)
      {
         ResourceDescriptor that = (ResourceDescriptor) obj;
         return this.getName().equals(that.getName());
      }
      else
      {
         return false;
      }
   }
   
   @Override
   public int hashCode()
   {
      return name.hashCode();
   }
   
   @Override
   public String toString()
   {
      return name + " (" + source.toString() + ")";
   }
   
}
