package org.jboss.testharness.impl.packaging;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Set;

import org.jboss.testharness.api.ResourceDescriptor;

/**
 * @author Hardy Ferentschik
 */
public interface TCKArtifact {
	TCKArtifact initialize();

	InputStream getJarAsStream() throws IOException;

	URL getJar() throws IOException;

	File getExplodedJar() throws IOException;

	void create() throws IOException;

	void writeArtifactToDisk(String outputDirectory) throws IOException;

	void writeArtifactToDisk(String outputDirectory, String fileName) throws IOException;

	String getDefaultName();

	Set<Class<?>> getClasses();

	Set<ResourceDescriptor> getResources();

	void addPackage(Package pkg);

	void addPackage(String packageName, boolean addRecursively);

	File getClassesRoot(File archiveRoot);

	String getClassesRoot();

	void setClassesRoot(String classesRoot);

	Class<?> getDeclaringClass();

	String getExtension();

	void setExtension(String extension);

	Set<ResourceDescriptor> getLibraries();

	File getLibraryRoot(File archiveRoot);

	void setLibrariesRoot(String libraryRoot);

	boolean isLibrariesSupported();

	void setLibrariesSupported(boolean librariesSupported);

	boolean isUnit();

	void setUnit(boolean unit);

	Class<? extends Throwable> getExpectedDeploymentException();

	void setExpectedDeploymentException(Class<? extends Throwable> expectedDeploymentException);

	boolean isRunLocally();

	void setRunLocally(boolean runLocally);

	String getXmlConfigDestination();

	void setXmlConfigDestination(String xmlConfigDest);

	ResourceDescriptor getXmlConfig();

	void skipIncludeXmlConfig(boolean skip);
}

