package org.jboss.testharness.impl.packaging.ear;

import java.lang.annotation.Documented;
import static java.lang.annotation.ElementType.TYPE;
import java.lang.annotation.Retention;
import static java.lang.annotation.RetentionPolicy.RUNTIME;
import java.lang.annotation.Target;

import org.jboss.testharness.impl.packaging.Resource;

/**
 * Override the default META-INF/ejb-jar.xml
 *
 * @author Pete Muir
 * @see Resource
 */
@Documented
@Retention(RUNTIME)
@Target(TYPE)
public @interface EjbJarXml {

	/**
	 * @return Location of the overriding file, relative to the current location or the
	 *         root this classpath
	 */
	String value();

}
