package org.jboss.testharness.impl.packaging.jsr303;

import java.lang.annotation.Documented;
import static java.lang.annotation.ElementType.TYPE;
import java.lang.annotation.Retention;
import static java.lang.annotation.RetentionPolicy.RUNTIME;
import java.lang.annotation.Target;

/**
 * Override the default (empty) META-INF/beans.xml
 *
 * @author Pete Muir
 * @see org.jboss.testharness.impl.packaging.Resource
 */
@Documented
@Retention(RUNTIME)
@Target(TYPE)
public @interface ValidationXml {

	/**
	 * @return Location of the overriding file, relative to the current location or the
	 * root this classpath.
	 */
	public abstract String value() default "META-INF/validation.xml";

}