/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.testharness.impl.runner.servlet;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import org.jboss.testharness.api.Configurable;
import org.jboss.testharness.api.Configuration;
import org.jboss.testharness.api.TestLauncher;
import org.jboss.testharness.api.TestResult;
import org.jboss.testharness.impl.runner.TestResultImpl;

public class ServletTestLauncher
implements TestLauncher,
Configurable {
    private Configuration configuration;

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TestResultImpl launchTest(Method method) throws IOException {
        Class<?> testClass = method.getDeclaringClass();
        String url = "http://" + this.configuration.getHost() + "/" + testClass.getName() + "/?outputMode=serializedObject&methodName=" + method.getName();
        long timeoutTime = System.currentTimeMillis() + (long)this.configuration.getConnectTimeout();
        boolean interrupted = false;
        while (timeoutTime > System.currentTimeMillis()) {
            URLConnection connection = new URL(url).openConnection();
            if (!(connection instanceof HttpURLConnection)) {
                throw new IllegalStateException("Not an http connection! " + connection);
            }
            HttpURLConnection httpConnection = (HttpURLConnection)connection;
            httpConnection.setUseCaches(false);
            httpConnection.setDefaultUseCaches(false);
            try {
                httpConnection.connect();
                if (httpConnection.getResponseCode() == 200) {
                    TestResultImpl result;
                    Object o;
                    ObjectInputStream ois = new ObjectInputStream(httpConnection.getInputStream());
                    try {
                        o = ois.readObject();
                    }
                    catch (ClassNotFoundException e) {
                        IOException ioException = new IOException();
                        ioException.initCause(e);
                        throw ioException;
                    }
                    ois.close();
                    if (!(o instanceof TestResult)) {
                        throw new IllegalStateException("Error reading test results - expected a TestResult but got " + o);
                    }
                    TestResultImpl testResultImpl = result = (TestResultImpl)o;
                    return testResultImpl;
                }
                if (httpConnection.getResponseCode() != 404) {
                    throw new IllegalStateException("Error launching test " + testClass.getName() + " at " + url + ". Got " + httpConnection.getResponseCode() + " (" + httpConnection.getResponseMessage() + ")");
                }
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException e) {
                    interrupted = true;
                }
            }
            finally {
                httpConnection.disconnect();
            }
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
        throw new IllegalStateException("Error launching test " + testClass.getName() + " at " + url + ". Kept on getting 404s.");
    }
}

