package org.jboss.testharness.impl.packaging.jsr299;

import org.jboss.testharness.api.ResourceDescriptor;
import org.jboss.testharness.impl.packaging.ResourceDescriptorImpl;
import org.jboss.testharness.impl.packaging.TCKArtifactDescriptor;
import static org.jboss.testharness.impl.util.Strings.isEmpty;

public class JSR299ArtifactDescriptor extends TCKArtifactDescriptor {

	public static final String BEANS_XML_DESTINATION = "META-INF/beans.xml";
	public static final String STANDARD_BEANS_XML_FILE_NAME = "org/jboss/testharness/impl/packaging/jsr299/default/beans.xml";

	private ResourceDescriptor beansXml;
	private final String beansXmlSourceFileName;
	private String beansXmlDesitnationFileName = BEANS_XML_DESTINATION;
	private boolean skipXmlConfig = false;

	public JSR299ArtifactDescriptor(Class<?> declaringClass, String beansXmlSourceFileName) {
		super( declaringClass );

		if ( isEmpty( beansXmlSourceFileName ) ) {
			this.beansXmlSourceFileName = STANDARD_BEANS_XML_FILE_NAME;
		}
		else {
			this.beansXmlSourceFileName = beansXmlSourceFileName;
		}
	}

	public JSR299ArtifactDescriptor(Class<?> declaringClass) {
		super( declaringClass );
		this.beansXmlSourceFileName = null;
		this.beansXml = null;
		this.skipIncludeXmlConfig( true );
		setLibrariesSupported( false );
	}

	@Override
	public JSR299ArtifactDescriptor initialize() {
		super.initialize();
		if ( beansXmlSourceFileName != null ) {
			this.beansXml = new ResourceDescriptorImpl( getXmlConfigDestination(), beansXmlSourceFileName );
		}
		if ( !skipXmlConfig && beansXml != null ) {
			getResources().add( beansXml );
		}
		return this;
	}

	public void setXmlConfigDestination(String xmlConfigDest) {
		beansXmlDesitnationFileName = xmlConfigDest;
	}

	public String getXmlConfigDestination() {
		return beansXmlDesitnationFileName;
	}

	public ResourceDescriptor getXmlConfig() {
		return beansXml;
	}

	public void skipIncludeXmlConfig(boolean skip) {
		this.skipXmlConfig = skip;
	}
}
