package org.jboss.testharness.impl.testng;

import java.util.List;

import org.jboss.testharness.impl.ConfigurationImpl;
import org.jboss.testharness.impl.packaging.IntegrationTest;
import org.testng.IMethodSelector;
import org.testng.IMethodSelectorContext;
import org.testng.ITestNGMethod;

public class DisableIntegrationTestsMethodSelector implements IMethodSelector
{

   private static final long serialVersionUID = 6034298835828495024L;

   public boolean includeMethod(IMethodSelectorContext context, ITestNGMethod method, boolean isTestMethod)
   {
      if (!ConfigurationImpl.get().isRunIntegrationTests() && method.getMethod().getDeclaringClass().isAnnotationPresent(IntegrationTest.class))
      {
         context.setStopped(true);
         return false;
      }
      else
      {
         return true;
      }
   }

   public void setTestMethods(List<ITestNGMethod> testMethods)
   {
      
   }
   
}
