package org.jboss.testharness.impl.packaging.jsr299;

import static org.jboss.testharness.impl.util.Strings.isEmpty;

import org.jboss.testharness.api.ResourceDescriptor;
import org.jboss.testharness.impl.packaging.ResourceDescriptorImpl;
import org.jboss.testharness.impl.packaging.TCKArtifactDescriptor;

public class JSR299ArtifactDescriptor extends TCKArtifactDescriptor
{

   public static final String BEANS_XML_DESTINATION = "META-INF/beans.xml";
   public static final String EXTENSION_DESTINATION = "META-INF/services/javax.enterprise.inject.spi.Extension";
   public static final String STANDARD_BEANS_XML_FILE_NAME = "org/jboss/testharness/impl/packaging/jsr299/default/beans.xml";

   private ResourceDescriptor beansXml;
   private ResourceDescriptor extension;
   private final String beansXmlSourceFileName;
   private final String extensionSourceFileName;
   private String beansXmlDesitnationFileName = BEANS_XML_DESTINATION;
   private String extensionDestinationFileName = EXTENSION_DESTINATION;
   private boolean skipXmlConfig = false;

   public JSR299ArtifactDescriptor(Class<?> declaringClass, String beansXmlSourceFileName, String extensionSourceFileName)
   {
      super(declaringClass);

      if (isEmpty(beansXmlSourceFileName))
      {
         this.beansXmlSourceFileName = STANDARD_BEANS_XML_FILE_NAME;
      }
      else
      {
         this.beansXmlSourceFileName = beansXmlSourceFileName;
      }
      if (isEmpty(extensionSourceFileName))
      {
         this.extensionSourceFileName = null;
      }
      else
      {
         this.extensionSourceFileName = extensionSourceFileName;
      }
   }

   public JSR299ArtifactDescriptor(Class<?> declaringClass)
   {
      super(declaringClass);
      this.beansXmlSourceFileName = null;
      this.extensionSourceFileName = null;
      this.beansXml = null;
      this.skipIncludeXmlConfig(true);
      setLibrariesSupported(false);
   }

   @Override
   public JSR299ArtifactDescriptor initialize()
   {
      super.initialize();
      if (beansXmlSourceFileName != null)
      {
         this.beansXml = new ResourceDescriptorImpl(getXmlConfigDestination(), beansXmlSourceFileName);
      }
      if (!skipXmlConfig && beansXml != null)
      {
         getResources().add(beansXml);
      }
      if (extensionSourceFileName != null)
      {
         this.extension = new ResourceDescriptorImpl(getClassesRoot() + "/" + extensionDestinationFileName, extensionSourceFileName);
      }
      if (!skipXmlConfig && extension != null)
      {
         getResources().add(extension);
      }
      return this;
   }

   public void setXmlConfigDestination(String xmlConfigDest)
   {
      beansXmlDesitnationFileName = xmlConfigDest;
   }

   public String getXmlConfigDestination()
   {
      return beansXmlDesitnationFileName;
   }

   public ResourceDescriptor getXmlConfig()
   {
      return beansXml;
   }

   public void skipIncludeXmlConfig(boolean skip)
   {
      this.skipXmlConfig = skip;
   }
}
