package org.jboss.testharness.impl.packaging.war;

import static org.jboss.testharness.impl.util.Reflections.loadResource;

import java.net.URL;

import org.jboss.testharness.impl.packaging.ResourceDescriptorImpl;
import org.jboss.testharness.impl.packaging.TCKArtifact;
import org.jboss.testharness.impl.packaging.jsr299.JSR299ArtifactDescriptor;
import org.jboss.testharness.impl.packaging.jsr303.JSR303ArtifactDescriptor;

/**
 * @todo Remove explicit instanceof checks
 */
public class WarArtifactDescriptor
{

   public static final String WEB_XML_DESTINATION = "WEB-INF/web.xml";
   public static final String PERSISTENCE_XML_DESTINATION = "WEB-INF/persistence.xml";
   public static final String STANDARD_WEB_XML_FILE_NAME = "org/jboss/testharness/impl/packaging/war/web.xml";
   public static final String CUSTOM_WEB_XML_FILE_NAME = "org/jboss/testharness/impl/packaging/war/custom-web.xml";

   public static TCKArtifact createWarArtifact(TCKArtifact tckArtifact, String webXmlSource, String persistenceXmlSource)
   {
      tckArtifact.setLibrariesRoot("WEB-INF/lib");
      tckArtifact.setClassesRoot("WEB-INF/classes/");
      tckArtifact.setExtension(".war");
      tckArtifact.setLibrariesSupported(true);
      if (tckArtifact instanceof JSR299ArtifactDescriptor)
      {
         tckArtifact.setXmlConfigDestination("WEB-INF/beans.xml");
      }
      else if (tckArtifact instanceof JSR303ArtifactDescriptor)
      {
         tckArtifact.setXmlConfigDestination("WEB-INF/classes/META-INF/validation.xml");
      }
      URL webXml;
      if (webXmlSource != null)
      {
         webXml = loadResource(webXmlSource);
      }
      else
      {
         URL customWebXml = loadResource(CUSTOM_WEB_XML_FILE_NAME);
         if (customWebXml == null)
         {
            webXml = loadResource(STANDARD_WEB_XML_FILE_NAME);
         }
         else
         {
            webXml = customWebXml;
         }
      }
      tckArtifact.getResources().add(new ResourceDescriptorImpl(WEB_XML_DESTINATION, webXml));
      if (persistenceXmlSource != null)
      {
         tckArtifact.getResources().add(new ResourceDescriptorImpl(PERSISTENCE_XML_DESTINATION, loadResource(persistenceXmlSource)));
      }
      
      return tckArtifact;
   }

   private WarArtifactDescriptor()
   {
   }

   @Override
   public String toString()
   {
      return "war, " + super.toString();
   }
}
