package org.jboss.testharness.impl.packaging.war;

import static java.lang.annotation.ElementType.TYPE;
import static java.lang.annotation.RetentionPolicy.RUNTIME;

import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;

import org.jboss.testharness.impl.packaging.Resource;

/**
 * Place a web.xml into the war
 * 
 * @see Resource
 * 
 * @author Pete Muir
 *
 */
@Documented
@Retention(RUNTIME)
@Target(TYPE)
public @interface WebXml
{
   
   /**
    * Location of the file, relative to the current location or the
    * root this classpath
    * 
    */
   String value();
   
}
