/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.testharness.impl.packaging;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import org.jboss.testharness.api.Configuration;
import org.jboss.testharness.api.ResourceDescriptor;
import org.jboss.testharness.impl.packaging.Artifact;
import org.jboss.testharness.impl.packaging.ArtifactScanner;
import org.jboss.testharness.impl.packaging.ArtifactType;
import org.jboss.testharness.impl.packaging.Classes;
import org.jboss.testharness.impl.packaging.ExpectedDeploymentException;
import org.jboss.testharness.impl.packaging.IntegrationTest;
import org.jboss.testharness.impl.packaging.Packaging;
import org.jboss.testharness.impl.packaging.PackagingType;
import org.jboss.testharness.impl.packaging.Resource;
import org.jboss.testharness.impl.packaging.ResourceDescriptorImpl;
import org.jboss.testharness.impl.packaging.Resources;
import org.jboss.testharness.impl.packaging.TCKArtifact;
import org.jboss.testharness.impl.packaging.TCKArtifactDescriptor;
import org.jboss.testharness.impl.packaging.ear.EarArtifactDescriptor;
import org.jboss.testharness.impl.packaging.ear.EjbJarArtifactDescriptor;
import org.jboss.testharness.impl.packaging.ear.EjbJarXml;
import org.jboss.testharness.impl.packaging.ear.PersistenceXml;
import org.jboss.testharness.impl.packaging.jsr299.BeansXml;
import org.jboss.testharness.impl.packaging.jsr299.Extension;
import org.jboss.testharness.impl.packaging.jsr299.JSR299ArtifactDescriptor;
import org.jboss.testharness.impl.packaging.jsr303.JSR303ArtifactDescriptor;
import org.jboss.testharness.impl.packaging.jsr303.ValidationXml;
import org.jboss.testharness.impl.packaging.war.WarArtifactDescriptor;
import org.jboss.testharness.impl.packaging.war.WebXml;
import org.jboss.testharness.impl.util.LogUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArtifactGenerator {
    private final Configuration configuration;

    public ArtifactGenerator(Configuration configuration) {
        if (configuration == null) {
            throw new IllegalArgumentException("configuration must not be null");
        }
        this.configuration = configuration;
    }

    public List<TCKArtifact> createArtifacts(String packageName) {
        HashSet classes = new HashSet();
        classes.addAll(new ArtifactScanner(packageName, null).getClasses());
        ArrayList<TCKArtifact> artifacts = new ArrayList<TCKArtifact>();
        for (Class clazz : classes) {
            artifacts.add(this.createArtifact(clazz));
        }
        return artifacts;
    }

    public void dumpArtifacts(String basePackageName) {
        if (basePackageName == null) {
            throw new IllegalArgumentException("Cannot dump artifacts as no package to dump from set. Specify org.jboss.testharness.testPackage");
        }
        List<TCKArtifact> artifacts = this.createArtifacts(basePackageName);
        File file = new File(this.configuration.getOutputDirectory());
        if (!file.exists()) {
            file.mkdirs();
        } else if (file.isFile()) {
            throw new IllegalStateException("Cannot use debug directory " + this.configuration.getOutputDirectory() + ", it already exists");
        }
        LogUtil.logger().info("Writing " + artifacts.size() + " artifact(s) to " + this.configuration.getOutputDirectory());
        for (TCKArtifact artifact : artifacts) {
            try {
                artifact.writeArtifactToDisk(this.configuration.getOutputDirectory());
                LogUtil.logger().info("Written artifact to disk " + artifact);
            }
            catch (IOException e) {
                LogUtil.logger().log(Level.WARNING, "Error writing artifact to disk " + artifact, e);
            }
        }
    }

    public TCKArtifact createArtifact(Class<?> declaringClass) {
        if (declaringClass.isAnnotationPresent(Artifact.class)) {
            return new ArtifactProcessor(declaringClass, this.configuration.isStandalone(), this.configuration.getLibraryDirectory()).createArtifact();
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ArtifactProcessor {
        private final boolean unit;
        private final boolean runLocally;
        private final boolean addDeclaringPackage;
        private final String beansXml;
        private final String extension;
        private final String validationXml;
        private final String ejbJarXml;
        private final String webXml;
        private final String persistenceXml;
        private final ArtifactType artifactType;
        private final PackagingType packagingType;
        private final Collection<ResourceDescriptor> resources;
        private final Collection<Class<?>> classes;
        private final Class<? extends Throwable> expectedDeploymentException;
        private final Set<ResourceDescriptor> extraLibraries;
        private final String[] packages;
        private final Class<?> declaringClass;
        private final boolean standalone;

        public ArtifactProcessor(Class<?> declaringClass, boolean standalone, String extraLibrariesDirectory) {
            this.standalone = standalone;
            this.declaringClass = declaringClass;
            if (!declaringClass.isAnnotationPresent(Artifact.class)) {
                throw new IllegalStateException("Unable to find @Artifact on " + declaringClass);
            }
            Artifact artifactAnn = declaringClass.getAnnotation(Artifact.class);
            this.addDeclaringPackage = artifactAnn.addCurrentPackage();
            this.artifactType = artifactAnn.artifactType();
            this.beansXml = declaringClass.isAnnotationPresent(BeansXml.class) ? this.asAbsolutePath(declaringClass.getAnnotation(BeansXml.class).value()) : null;
            this.extension = declaringClass.isAnnotationPresent(Extension.class) ? this.asAbsolutePath(declaringClass.getAnnotation(Extension.class).value()) : null;
            this.validationXml = declaringClass.isAnnotationPresent(ValidationXml.class) ? this.asAbsolutePath(declaringClass.getAnnotation(ValidationXml.class).value()) : null;
            this.packagingType = declaringClass.isAnnotationPresent(Packaging.class) ? declaringClass.getAnnotation(Packaging.class).value() : PackagingType.WAR;
            this.ejbJarXml = declaringClass.isAnnotationPresent(EjbJarXml.class) ? this.asAbsolutePath(declaringClass.getAnnotation(EjbJarXml.class).value()) : null;
            this.webXml = declaringClass.isAnnotationPresent(WebXml.class) ? this.asAbsolutePath(declaringClass.getAnnotation(WebXml.class).value()) : null;
            this.persistenceXml = declaringClass.isAnnotationPresent(PersistenceXml.class) ? this.asAbsolutePath(declaringClass.getAnnotation(PersistenceXml.class).value()) : null;
            if (declaringClass.isAnnotationPresent(IntegrationTest.class)) {
                this.unit = false;
                this.runLocally = declaringClass.getAnnotation(IntegrationTest.class).runLocally();
            } else {
                this.unit = true;
                this.runLocally = false;
            }
            this.resources = new ArrayList<ResourceDescriptor>();
            if (declaringClass.isAnnotationPresent(Resource.class)) {
                this.resources.add(this.asResourceDescriptor(declaringClass.getAnnotation(Resource.class)));
            }
            if (declaringClass.isAnnotationPresent(Resources.class)) {
                this.resources.addAll(this.asResourceDescriptors(declaringClass.getAnnotation(Resources.class).value()));
            }
            if (declaringClass.isAnnotationPresent(Classes.class)) {
                this.classes = Arrays.asList(declaringClass.getAnnotation(Classes.class).value());
                this.packages = declaringClass.getAnnotation(Classes.class).packages();
            } else {
                this.classes = Collections.emptyList();
                this.packages = new String[0];
            }
            this.expectedDeploymentException = declaringClass.isAnnotationPresent(ExpectedDeploymentException.class) ? declaringClass.getAnnotation(ExpectedDeploymentException.class).value() : null;
            if (extraLibrariesDirectory != null) {
                File directory = new File(extraLibrariesDirectory);
                this.extraLibraries = new HashSet<ResourceDescriptor>();
                if (directory.isDirectory()) {
                    for (File file : directory.listFiles(new FilenameFilter(){

                        public boolean accept(File dir, String name) {
                            return name.endsWith(".jar");
                        }
                    })) {
                        try {
                            this.extraLibraries.add(new ResourceDescriptorImpl(file.getName(), file.toURI().toURL()));
                        }
                        catch (IOException e) {
                            LogUtil.logger().log(Level.WARNING, "Unable to load extra library", e);
                        }
                    }
                }
            } else {
                this.extraLibraries = Collections.emptySet();
            }
        }

        public TCKArtifact createArtifact() {
            TCKArtifact artifact = ArtifactProcessor.newArtifact(this.artifactType, this.packagingType, this.declaringClass, this.beansXml, this.extension, this.validationXml, this.ejbJarXml, this.webXml, this.persistenceXml, this.standalone, this.addDeclaringPackage);
            artifact.setUnit(this.unit);
            artifact.setRunLocally(this.runLocally);
            artifact.setExpectedDeploymentException(this.expectedDeploymentException);
            artifact.getClasses().addAll(this.classes);
            artifact.getResources().removeAll(this.resources);
            artifact.getResources().addAll(this.resources);
            artifact.getLibraries().addAll(this.extraLibraries);
            for (String packageName : this.packages) {
                artifact.addPackage(packageName, false);
            }
            return artifact;
        }

        private Collection<ResourceDescriptor> asResourceDescriptors(Resource[] resources) {
            ArrayList<ResourceDescriptor> resourceDescriptorImpls = new ArrayList<ResourceDescriptor>();
            for (Resource resource : resources) {
                resourceDescriptorImpls.add(this.asResourceDescriptor(resource));
            }
            return resourceDescriptorImpls;
        }

        private ResourceDescriptor asResourceDescriptor(Resource resource) {
            return new ResourceDescriptorImpl(resource.destination(), this.asAbsolutePath(resource.source()));
        }

        private String asAbsolutePath(String path) {
            if (path.startsWith("/")) {
                return path.substring(1);
            }
            return this.declaringClass.getPackage().getName().replace(".", "/") + "/" + path;
        }

        private static TCKArtifact newArtifact(ArtifactType artifactType, PackagingType packagingType, Class<?> declaringClass, String beansXml, String extension, String validationXml, String ejbJarXml, String webXml, String persistenceXml, boolean standalone, boolean addDeclaringPackage) {
            TCKArtifact artifact;
            if (!standalone && packagingType.equals((Object)PackagingType.WAR)) {
                artifact = ArtifactProcessor.createAndInitalizeWarArtifact(artifactType, declaringClass, beansXml, extension, validationXml, ejbJarXml, webXml, persistenceXml, addDeclaringPackage);
            } else if (!standalone && packagingType.equals((Object)PackagingType.EAR)) {
                artifact = ArtifactProcessor.createAndInitalizeEarArtifact(artifactType, declaringClass, beansXml, extension, validationXml, ejbJarXml, webXml, persistenceXml, addDeclaringPackage);
            } else {
                artifact = ArtifactProcessor.createBaseArtifact(artifactType, declaringClass, beansXml, extension, validationXml);
                if (addDeclaringPackage) {
                    artifact.addPackage(declaringClass.getPackage());
                }
                artifact.initialize();
            }
            return artifact;
        }

        private static TCKArtifact createAndInitalizeEarArtifact(ArtifactType artifactType, Class<?> declaringClass, String beansXml, String extension, String validationXml, String ejbJarXml, String webXml, String persistenceXml, boolean addDeclaringPackage) {
            TCKArtifact ejbJar = EjbJarArtifactDescriptor.createEjbJarArtifact(ArtifactProcessor.createBaseArtifact(artifactType, declaringClass, beansXml, extension, validationXml), ejbJarXml, persistenceXml);
            if (addDeclaringPackage) {
                ejbJar.addPackage(declaringClass.getPackage());
            }
            TCKArtifact war = WarArtifactDescriptor.createWarArtifact(ArtifactProcessor.createBaseArtifact(artifactType, declaringClass, null, null, validationXml), webXml, null);
            TCKArtifact ear = EarArtifactDescriptor.createEarArtifact(ArtifactProcessor.createBaseArtifact(artifactType, declaringClass, null, null, validationXml), ejbJar, war);
            ear.initialize();
            return ear;
        }

        private static TCKArtifact createAndInitalizeWarArtifact(ArtifactType artifactType, Class<?> declaringClass, String beansXml, String extension, String validationXml, String ejbJarXml, String webXml, String persistenceXml, boolean addDeclaringPackage) {
            TCKArtifact artifact = ArtifactProcessor.createBaseArtifact(artifactType, declaringClass, beansXml, extension, validationXml);
            artifact = WarArtifactDescriptor.createWarArtifact(artifact, webXml, persistenceXml).initialize();
            if (ejbJarXml != null) {
                artifact.getResources().add(new ResourceDescriptorImpl("WEB-INF/ejb-jar.xml", ejbJarXml));
            }
            if (addDeclaringPackage) {
                artifact.addPackage(declaringClass.getPackage());
            }
            return artifact;
        }

        private static TCKArtifact createBaseArtifact(ArtifactType artifactType, Class<?> declaringClass, String beansXml, String extension, String validationXml) {
            TCKArtifactDescriptor artifact = ArtifactType.JSR303.equals((Object)artifactType) ? new JSR303ArtifactDescriptor(declaringClass, validationXml) : new JSR299ArtifactDescriptor(declaringClass, beansXml, extension);
            return artifact;
        }

        public boolean isUnit() {
            return this.unit;
        }
    }
}

