/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.testharness.impl.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import org.jboss.testharness.impl.packaging.ArtifactDescriptor;
import org.jboss.testharness.impl.util.EnumerationIterable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Reflections {
    public static InputStream loadResourceAsStream(String name) {
        InputStream is = null;
        if (Thread.currentThread().getContextClassLoader() != null) {
            is = Thread.currentThread().getContextClassLoader().getResourceAsStream(name);
        }
        if (is == null) {
            is = ArtifactDescriptor.class.getResourceAsStream(name);
        }
        return is;
    }

    public static URL loadResource(String name) {
        URL url = null;
        if (Thread.currentThread().getContextClassLoader() != null) {
            url = Thread.currentThread().getContextClassLoader().getResource(name);
        }
        if (url == null) {
            url = ArtifactDescriptor.class.getResource(name);
        }
        return url;
    }

    public static Class<?> loadClass(String name) {
        Class<?> clazz = null;
        if (Thread.currentThread().getContextClassLoader() != null) {
            try {
                clazz = Thread.currentThread().getContextClassLoader().loadClass(name);
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
        if (clazz == null) {
            try {
                clazz = Class.forName(name);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return clazz;
    }

    public static Iterable<URL> loadResources(String name) throws IOException {
        Enumeration<URL> urls = null;
        if (Thread.currentThread().getContextClassLoader() != null) {
            urls = Thread.currentThread().getContextClassLoader().getResources(name);
        }
        if (urls == null) {
            urls = ArtifactDescriptor.class.getClassLoader().getResources(name);
        }
        return new EnumerationIterable<URL>(urls);
    }
}

