package org.jboss.testharness.impl;

import org.jboss.testharness.api.Configuration;
import org.jboss.testharness.api.ConfigurationBuilder;
import org.jboss.testharness.properties.PropertiesManager;

public class ConfigurationFactory
{
   
   private static Configuration current;
   
   public static <T extends Configuration> T get(Class<T> expectedType)
   {
      if (current == null)
      {
         PropertiesManager properties = new PropertiesManager();
         ConfigurationBuilder builder = properties.getInstanceValue(ConfigurationBuilder.PROPERTY_NAME, ConfigurationBuilder.class, false);
         if (builder == null)
         {
            builder = new PropertiesBasedConfigurationBuilder<ConfigurationImpl>(new ConfigurationImpl());
         }
         current = builder.init().getConfiguration();
      }
      try
      {
         return expectedType.cast(current);
      }
      catch (ClassCastException e)
      {
         throw new IllegalStateException("Error loading configuration, check that you have the correct ConfigurationBuilder specified on your build classpath");
      }
      
   }
   
   public static Configuration get()
   {
      return get(Configuration.class);
   }

}
