package org.jboss.testharness.impl;

import static org.jboss.testharness.api.Configuration.CONNECT_TIMEOUT_PROPERTY_NAME;
import static org.jboss.testharness.api.Configuration.DEFAULT_CONNECT_DELAY;
import static org.jboss.testharness.api.Configuration.DEFAULT_HOST;
import static org.jboss.testharness.api.Configuration.DEFAULT_LIBRARY_DIRECTORY;
import static org.jboss.testharness.api.Configuration.DEFAULT_OUTPUT_DIRECTORY;
import static org.jboss.testharness.api.Configuration.DEFAULT_RUN_INTEGRATION_TESTS;
import static org.jboss.testharness.api.Configuration.DEFAULT_STANDALONE;
import static org.jboss.testharness.api.Configuration.HOST_PROPERTY_NAME;
import static org.jboss.testharness.api.Configuration.LIBRARY_DIRECTORY_PROPERTY_NAME;
import static org.jboss.testharness.api.Configuration.OUTPUT_DIRECTORY_PROPERTY_NAME;
import static org.jboss.testharness.api.Configuration.RUN_INTEGRATION_TESTS_PROPERTY_NAME;
import static org.jboss.testharness.api.Configuration.STANDALONE_PROPERTY_NAME;
import static org.jboss.testharness.api.Configuration.TEST_PACKAGE_PROPERTY_NAME;

import org.jboss.testharness.AbstractTest;
import org.jboss.testharness.api.Configurable;
import org.jboss.testharness.api.Configuration;
import org.jboss.testharness.api.ConfigurationBuilder;
import org.jboss.testharness.api.TestLauncher;
import org.jboss.testharness.properties.PropertiesManager;
import org.jboss.testharness.spi.Containers;
import org.jboss.testharness.spi.StandaloneContainers;

public class PropertiesBasedConfigurationBuilder<T extends Configuration> implements ConfigurationBuilder
{
   
   private final PropertiesManager propertiesManager;
   private final T configuration;
   
   public PropertiesBasedConfigurationBuilder(T configuration)
   {
      this.propertiesManager = new PropertiesManager();
      this.configuration = configuration;
      
      configuration.setOutputDirectory(propertiesManager.getStringValue(OUTPUT_DIRECTORY_PROPERTY_NAME, DEFAULT_OUTPUT_DIRECTORY, false));
      configuration.setStandalone(propertiesManager.getBooleanValue(STANDALONE_PROPERTY_NAME, DEFAULT_STANDALONE, false));
      configuration.setRunIntegrationTests(propertiesManager.getBooleanValue(RUN_INTEGRATION_TESTS_PROPERTY_NAME, DEFAULT_RUN_INTEGRATION_TESTS, false));
      configuration.setConnectTimeout(propertiesManager.getIntValue(CONNECT_TIMEOUT_PROPERTY_NAME, DEFAULT_CONNECT_DELAY, false));
      configuration.setLibraryDirectory(propertiesManager.getStringValue(LIBRARY_DIRECTORY_PROPERTY_NAME, DEFAULT_LIBRARY_DIRECTORY, false));
      configuration.setHost(propertiesManager.getStringValue(HOST_PROPERTY_NAME, DEFAULT_HOST, false));
      configuration.setTestPackage(propertiesManager.getStringValue(TEST_PACKAGE_PROPERTY_NAME, null, false));
   }
   
   /* (non-Javadoc)
    * @see org.jboss.testharness.impl.ConfigurationBuilder#loadSPIImplementation()
    */
   public ConfigurationBuilder init()
   {
      if (!AbstractTest.isInContainer())
      {
         configuration.setInContainerTestLauncher(getInstanceValue(TestLauncher.PROPERTY_NAME, TestLauncher.class, configuration.isRunIntegrationTests() || !configuration.isStandalone()));
         configuration.setContainers(getInstanceValue(Containers.PROPERTY_NAME, Containers.class, !configuration.isStandalone() || configuration.isRunIntegrationTests()));
         configuration.setStandaloneContainers(getInstanceValue(StandaloneContainers.PROPERTY_NAME, StandaloneContainers.class, configuration.isStandalone()));
      }
      return this;
   }
   
   protected <C> C getInstanceValue(String propertyName, Class<C> expectedType, boolean required)
   {
      C instance = propertiesManager.getInstanceValue(propertyName, expectedType, required);
      if (instance instanceof Configurable)
      {
         ((Configurable) instance).setConfiguration(configuration);
      }
      return instance;
   }
   
   /* (non-Javadoc)
    * @see org.jboss.testharness.impl.ConfigurationBuilder#getConfiguration()
    */
   public T getConfiguration()
   {
      return configuration;
   }
   
   protected PropertiesManager getDeploymentProperties()
   {
      return propertiesManager;
   }
   
}
