package org.jboss.testharness;

import java.lang.reflect.Method;

import org.jboss.testharness.api.TestLauncher.InvocationContext;
import org.testng.IHookCallBack;
import org.testng.ITestResult;

public class TestNGInvocationContext implements InvocationContext
{
   
   private final ITestResult testResult;
   private final IHookCallBack callback;
   
   public TestNGInvocationContext(ITestResult testResult, IHookCallBack callback)
   {
      this.testResult = testResult;
      this.callback = callback;
   }

   public Method getMethod()
   {
      return testResult.getMethod().getMethod();
   }

   public void proceed()
   {
      callback.runTestMethod(testResult);
   }

}
