package org.jboss.testharness.impl.packaging;

import static java.lang.annotation.ElementType.TYPE;
import static java.lang.annotation.RetentionPolicy.RUNTIME;

import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;

/**
 * Mark this artifact as expecting to fail a deployment with the given exception
 * or some subtype of it.
 * 
 * @author Pete Muir
 *
 */
@Documented
@Retention(RUNTIME)
@Target(TYPE)
public @interface ExpectedDeploymentException
{
   
   Class<? extends Throwable> value();
   
}
