package org.jboss.testharness.impl.packaging;

import static java.lang.annotation.ElementType.TYPE;
import static java.lang.annotation.RetentionPolicy.RUNTIME;

import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;

import org.jboss.testharness.impl.packaging.jsr299.BeansXml;

/**
 * Specify an additional resource to be added to the artifact. You can
 * specify muliple resources by nesting multiple @Resource annotations
 * within a @Resources annotation.
 * 
 * @see Resources
 * @see BeansXml
 * 
 * @author Pete Muir
 *
 */
@Documented
@Retention(RUNTIME)
@Target(TYPE)
public @interface Resource
{
   
   /**
    * Location, relative to the current package, or to the current archive
    * to find the resource file
    * 
    */
   String source();
   
   /**
    * Destination for the resource file within the generated artifact
    * 
    */
   String destination();
   
}
