package org.jboss.testharness.impl.packaging.jsr303;

import static org.jboss.testharness.impl.util.Strings.isEmpty;

import org.jboss.testharness.api.ResourceDescriptor;
import org.jboss.testharness.impl.packaging.ResourceDescriptorImpl;
import org.jboss.testharness.impl.packaging.TCKArtifactDescriptor;

public class JSR303ArtifactDescriptor extends TCKArtifactDescriptor {

	public static final String VALIDATION_XML_DESTINATION = "META-INF/validation.xml";

	private ResourceDescriptor validationXml;
	private final String validationXmlSourceFileName;
	private String validationXmlDesitnationFileName = VALIDATION_XML_DESTINATION;
	private boolean skipXmlConfig = false;

	public JSR303ArtifactDescriptor(Class<?> declaringClass, String validationXmlSourceFileName) {
		super( declaringClass );
		if ( !isEmpty( validationXmlSourceFileName ) ) {
			this.validationXmlSourceFileName = validationXmlSourceFileName;
		}
		else {
			this.validationXmlSourceFileName = null;
		}
	}

	@Override
	public TCKArtifactDescriptor initialize() {
		super.initialize();
		if ( validationXmlSourceFileName != null ) {
			validationXml = new ResourceDescriptorImpl(
					getXmlConfigDestination(), validationXmlSourceFileName
			);
		}
		if ( !skipXmlConfig && validationXml != null ) {
			getResources().add( validationXml );                                                                                                                            
		}
		return this;
	}

	public String getXmlConfigDestination() {
		return validationXmlDesitnationFileName;
	}

	public void setXmlConfigDestination(String xmlConfigDest) {
		this.validationXmlDesitnationFileName = xmlConfigDest;
	}

	public ResourceDescriptor getXmlConfig() {
		return validationXml;
	}

	public void skipIncludeXmlConfig(boolean skip) {
		this.skipXmlConfig = skip;
	}
	
	public void setSkipBeansXmlConfig(boolean skipBeansXmlConfig)
	{
	   // TODO Auto-generated method stub
	   
	}
}