/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.faces.mock;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import org.easymock.EasyMock;
import org.easymock.IMocksControl;
import org.easymock.internal.AssertionErrorWrapper;
import org.easymock.internal.Invocation;
import org.easymock.internal.LastControl;
import org.easymock.internal.MocksControl;
import org.easymock.internal.RecordState;
import org.easymock.internal.RuntimeExceptionWrapper;
import org.easymock.internal.ThrowableWrapper;
import org.jboss.test.faces.mock.application.MockApplication;
import org.jboss.test.faces.mock.application.MockApplicationFactory;
import org.jboss.test.faces.mock.application.MockNavigationHandler;
import org.jboss.test.faces.mock.application.MockResource;
import org.jboss.test.faces.mock.application.MockResourceHandler;
import org.jboss.test.faces.mock.application.MockStateManager;
import org.jboss.test.faces.mock.application.MockViewHandler;
import org.jboss.test.faces.mock.component.MockUICommand;
import org.jboss.test.faces.mock.component.MockUIComponent;
import org.jboss.test.faces.mock.component.MockUIComponentBase;
import org.jboss.test.faces.mock.component.MockUIInput;
import org.jboss.test.faces.mock.component.MockUIOutput;
import org.jboss.test.faces.mock.component.MockUIViewRoot;
import org.jboss.test.faces.mock.component.behavior.MockClientBehaviorContext;
import org.jboss.test.faces.mock.component.visit.MockVisitContext;
import org.jboss.test.faces.mock.component.visit.MockVisitContextFactory;
import org.jboss.test.faces.mock.context.MockExceptionHandler;
import org.jboss.test.faces.mock.context.MockExceptionHandlerFactory;
import org.jboss.test.faces.mock.context.MockExternalContext;
import org.jboss.test.faces.mock.context.MockExternalContextFactory;
import org.jboss.test.faces.mock.context.MockFacesContext;
import org.jboss.test.faces.mock.context.MockFacesContextFactory;
import org.jboss.test.faces.mock.context.MockFlash;
import org.jboss.test.faces.mock.context.MockPartialViewContext;
import org.jboss.test.faces.mock.context.MockPartialViewContextFactory;
import org.jboss.test.faces.mock.context.MockResponseWriter;
import org.jboss.test.faces.mock.el.MockELContext;
import org.jboss.test.faces.mock.el.MockExpressionFactory;
import org.jboss.test.faces.mock.el.MockMethodBinding;
import org.jboss.test.faces.mock.el.MockMethodExpression;
import org.jboss.test.faces.mock.el.MockPropertyResolver;
import org.jboss.test.faces.mock.el.MockValueBinding;
import org.jboss.test.faces.mock.el.MockValueExpression;
import org.jboss.test.faces.mock.el.MockVariableResolver;
import org.jboss.test.faces.mock.lifecycle.MockLifecycle;
import org.jboss.test.faces.mock.lifecycle.MockLifecycleFactory;
import org.jboss.test.faces.mock.render.MockClientBehaviorRenderer;
import org.jboss.test.faces.mock.render.MockRenderKit;
import org.jboss.test.faces.mock.render.MockRenderKitFactory;
import org.jboss.test.faces.mock.render.MockRenderer;
import org.jboss.test.faces.mock.render.MockResponseStateManager;
import org.jboss.test.faces.mock.view.MockStateManagementStrategy;
import org.jboss.test.faces.mock.view.MockViewDeclarationLanguage;
import org.jboss.test.faces.mock.view.MockViewDeclarationLanguageFactory;

public class FacesMockController {
    private static final Class<?>[] mockClasses = new Class[]{MockFacesContext.class, MockFacesContextFactory.class, MockExternalContext.class, MockExternalContextFactory.class, MockFlash.class, MockExceptionHandler.class, MockExceptionHandlerFactory.class, MockPartialViewContext.class, MockPartialViewContextFactory.class, MockResponseWriter.class, MockApplication.class, MockApplicationFactory.class, MockViewHandler.class, MockNavigationHandler.class, MockStateManager.class, MockResource.class, MockResourceHandler.class, MockUIComponent.class, MockUIComponentBase.class, MockUIViewRoot.class, MockUIOutput.class, MockUIInput.class, MockUICommand.class, MockClientBehaviorContext.class, MockVisitContext.class, MockVisitContextFactory.class, MockMethodBinding.class, MockValueBinding.class, MockPropertyResolver.class, MockVariableResolver.class, MockLifecycle.class, MockLifecycleFactory.class, MockClientBehaviorRenderer.class, MockRenderer.class, MockRenderKit.class, MockRenderKitFactory.class, MockResponseStateManager.class, MockViewDeclarationLanguage.class, MockViewDeclarationLanguageFactory.class, MockStateManagementStrategy.class, MockValueExpression.class, MockMethodExpression.class, MockExpressionFactory.class, MockELContext.class};

    public static <T> T createMock(String name, Class<T> clazz, IMocksControl control) throws ClassNotFoundException {
        for (Class<?> mockClass : mockClasses) {
            if (!clazz.isAssignableFrom(mockClass)) continue;
            try {
                Constructor<?> constructor = mockClass.getConstructor(IMocksControl.class, String.class);
                return (T)constructor.newInstance(control, name);
            }
            catch (Exception e) {
                throw new ClassNotFoundException("Cannot instantiate object for class " + clazz.getName(), e);
            }
        }
        throw new ClassNotFoundException("Mock object for class " + clazz.getName() + " not found");
    }

    public static <T> T createMock(String name, Class<T> clazz) throws ClassNotFoundException {
        return FacesMockController.createMock(name, clazz, EasyMock.createControl());
    }

    public static <T> T createMock(Class<T> clazz) throws ClassNotFoundException {
        return FacesMockController.createMock(null, clazz, EasyMock.createControl());
    }

    public static <T> T invokeCurrent(MockObject target, Object ... args) {
        StackTraceElement[] stackTrace;
        for (StackTraceElement traceElement : stackTrace = Thread.currentThread().getStackTrace()) {
            Method[] methods;
            if (!traceElement.getClassName().equals(target.getClass().getName())) continue;
            String methodName = traceElement.getMethodName();
            for (Method method : methods = target.getClass().getDeclaredMethods()) {
                if (!method.getName().equals(methodName)) continue;
                Class<?>[] parameterTypes = method.getParameterTypes();
                boolean acceptParameters = false;
                if (null == args) {
                    acceptParameters = parameterTypes.length == 0;
                } else if (parameterTypes.length == args.length) {
                    acceptParameters = true;
                    for (int i = 0; i < parameterTypes.length; ++i) {
                        if (null == args[i] || parameterTypes[i].isInstance(args[i]) || parameterTypes[i].isPrimitive()) continue;
                        acceptParameters = false;
                        break;
                    }
                }
                if (!acceptParameters) continue;
                return FacesMockController.invokeMethod(target, method, args);
            }
        }
        throw new RuntimeException("cannot find current method");
    }

    public static <T> T invokeMethod(MockObject target, Method method, Object ... args) {
        IMocksControl mcontrol = target.getControl();
        return FacesMockController.invokeMethod(mcontrol, target, method, args);
    }

    public static <T> T invokeMethod(IMocksControl control, MockObject target, Method method, Object ... args) throws AssertionError, Error {
        if (null != control) {
            try {
                MocksControl mcontrol = (MocksControl)control;
                if (mcontrol.getState() instanceof RecordState) {
                    LastControl.reportLastControl((MocksControl)mcontrol);
                }
                return (T)mcontrol.getState().invoke(new Invocation((Object)target, method, args));
            }
            catch (RuntimeExceptionWrapper e) {
                throw (RuntimeException)e.getRuntimeException().fillInStackTrace();
            }
            catch (AssertionErrorWrapper e) {
                throw (AssertionError)((Object)((Throwable)((Object)e.getAssertionError())).fillInStackTrace());
            }
            catch (ThrowableWrapper t) {
                Throwable wrappedThrowable = t.getThrowable().fillInStackTrace();
                if (wrappedThrowable instanceof RuntimeException) {
                    throw (RuntimeException)wrappedThrowable;
                }
                if (wrappedThrowable instanceof Error) {
                    throw (Error)wrappedThrowable;
                }
                throw new RuntimeException(t.fillInStackTrace());
            }
            catch (Throwable t) {
                throw new RuntimeException(t.fillInStackTrace());
            }
        }
        return null;
    }

    public static Method findMethod(Class<?> clazz, String name, Class<?> ... classes) {
        try {
            return clazz.getMethod(name, classes);
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    public static interface MockObject {
        public IMocksControl getControl();
    }
}

