/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.faces.mock.component;

import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import org.easymock.EasyMock;
import org.jboss.test.faces.mock.FacesMock;
import org.jboss.test.faces.mock.component.Facet;
import org.jboss.test.faces.mock.component.TreeBuilder;
import org.jboss.test.faces.mock.component.TreeBuilderImpl;

public class ViewBuilder
extends TreeBuilderImpl<UIViewRoot> {
    protected ViewBuilder(UIViewRoot component) {
        super(component);
    }

    public static ViewBuilder createView() {
        return ViewBuilder.createView(FacesMock.createMock(UIViewRoot.class));
    }

    public static ViewBuilder createView(UIViewRoot mockViewRoot) {
        ViewBuilder treeBuilder = new ViewBuilder(mockViewRoot);
        EasyMock.expect((Object)mockViewRoot.getParent()).andStubReturn(null);
        return treeBuilder;
    }

    public ViewBuilder setViewId(String viewId) {
        EasyMock.expect((Object)((UIViewRoot)this.getComponent()).getViewId()).andStubReturn((Object)viewId);
        return this;
    }

    public ViewBuilder children(TreeBuilder<?> ... builders) {
        super.children(builders);
        return this;
    }

    public ViewBuilder facets(Facet<?> ... facets) {
        super.facets(facets);
        return this;
    }

    public static TreeBuilder<UIComponent> component() {
        return ViewBuilder.component(FacesMock.createMock(UIComponent.class));
    }

    public static <T extends UIComponent> TreeBuilder<T> component(Class<T> childType) {
        return ViewBuilder.component((UIComponent)FacesMock.createMock(childType));
    }

    public static <T extends UIComponent> TreeBuilder<T> component(T child) {
        TreeBuilderImpl<T> treeBuilder = ViewBuilder.createComponent(child);
        return treeBuilder;
    }

    private static <T extends UIComponent> TreeBuilderImpl<T> createComponent(T child) {
        TreeBuilderImpl<T> treeBuilder = new TreeBuilderImpl<T>(child);
        return treeBuilder;
    }

    public static Facet<UIComponent> facet(String name) {
        return ViewBuilder.facet(name, FacesMock.createMock(UIComponent.class));
    }

    public static <T extends UIComponent> Facet<T> facet(String name, Class<T> childType) {
        return ViewBuilder.facet(name, (UIComponent)FacesMock.createMock(childType));
    }

    public static <T extends UIComponent> Facet<T> facet(String name, T child) {
        TreeBuilderImpl<T> treeBuilder = ViewBuilder.createComponent(child);
        return new Facet<T>(name, treeBuilder);
    }
}

