/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.faces.writer;

import java.util.LinkedHashMap;
import javax.faces.component.UIComponent;
import org.jboss.test.faces.FacesTestException;
import org.jboss.test.faces.writer.Attribute;
import org.jboss.test.faces.writer.Record;
import org.jboss.test.faces.writer.RecordBase;

public class ElementRecord
extends RecordBase
implements Record {
    private LinkedHashMap<String, Attribute> attributes = new LinkedHashMap();
    private final String name;
    private final UIComponent component;

    public ElementRecord(String name, UIComponent component) {
        this.component = component;
        this.name = name;
    }

    public void addAttribute(Attribute attr) {
        if (this.getChildren().size() > 0) {
            throw new FacesTestException("Attempt to write attribute after element content");
        }
        if (this.attributes.containsKey(attr.getName())) {
            throw new FacesTestException("Element alresdy has attribute");
        }
        this.attributes.put(attr.getName(), attr);
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        String content;
        StringBuilder text = new StringBuilder();
        text.append("<").append(this.name);
        if (this.attributes.size() > 0) {
            for (Attribute attr : this.attributes.values()) {
                text.append(" ").append(attr.toString());
            }
        }
        if ((content = super.toString()).length() > 0) {
            text.append(">").append(content);
            text.append("</").append(this.name).append(">");
        } else {
            text.append("/>");
        }
        return text.toString();
    }

    public boolean containsAttribute(String name) {
        return this.attributes.containsKey(name);
    }

    public Attribute getAttribute(String name2) {
        return this.attributes.get(name2);
    }
}

