/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.faces.mockito;

import java.util.HashMap;
import javax.el.ELContext;
import javax.faces.FactoryFinder;
import javax.faces.application.Application;
import javax.faces.application.ApplicationFactory;
import javax.faces.application.ViewHandler;
import javax.faces.context.ExceptionHandlerFactory;
import javax.faces.context.ExternalContext;
import javax.faces.context.ExternalContextFactory;
import javax.faces.context.FacesContext;
import javax.faces.context.FacesContextFactory;
import javax.faces.context.PartialViewContextFactory;
import javax.faces.lifecycle.LifecycleFactory;
import javax.faces.render.RenderKit;
import javax.faces.render.RenderKitFactory;
import javax.faces.render.ResponseStateManager;
import javax.faces.view.facelets.TagHandlerDelegateFactory;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jboss.test.faces.mockito.MockFacesContext;
import org.jboss.test.faces.mockito.factory.FactoryMock;
import org.jboss.test.faces.mockito.factory.FactoryMockingService;
import org.jboss.test.faces.writer.RecordingResponseWriter;
import org.mockito.Mockito;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MockFacesEnvironment {
    private MockFacesContext facesContext;
    private boolean withFactories = false;
    private ExternalContext externalContext;
    private ELContext elContext;
    private ServletContext context;
    private HttpServletRequest request;
    private HttpServletResponse response;
    private Application application;
    private ViewHandler viewHandler;
    private RenderKit renderKit;
    private ResponseStateManager responseStateManager;
    private RecordingResponseWriter responseWriter;
    private ApplicationFactory applicationFactory;
    private FacesContextFactory facesContextFactory;
    private RenderKitFactory renderKitFactory;
    private LifecycleFactory lifecycleFactory;
    private TagHandlerDelegateFactory tagHandlerDelegateFactory;
    private ExceptionHandlerFactory exceptionHandlerFactory;
    private PartialViewContextFactory partialViewContextFactory;
    private ExternalContextFactory externalContextFactory;
    private static boolean jsf2;
    private FactoryMockingService service = FactoryMockingService.getInstance();

    public MockFacesEnvironment() {
        MockFacesContext mockFacesContext = new MockFacesContext();
        this.facesContext = (MockFacesContext)((Object)Mockito.spy((Object)((Object)mockFacesContext)));
        MockFacesContext.setCurrentInstance(this.facesContext);
        this.withExternalContext();
    }

    public MockFacesEnvironment withExternalContext() {
        this.externalContext = (ExternalContext)Mockito.mock(ExternalContext.class);
        this.recordExternalContext();
        return this;
    }

    private void recordExternalContext() {
        Mockito.when((Object)this.facesContext.getExternalContext()).thenReturn((Object)this.externalContext);
        Mockito.when((Object)this.externalContext.getApplicationMap()).thenReturn(new HashMap());
    }

    public MockFacesEnvironment withELContext() {
        this.elContext = (ELContext)Mockito.mock(ELContext.class);
        this.recordELContext();
        return this;
    }

    private void recordELContext() {
        Mockito.when((Object)this.facesContext.getELContext()).thenReturn((Object)this.elContext);
    }

    public MockFacesEnvironment withServletRequest() {
        if (null == this.externalContext) {
            this.withExternalContext();
        }
        this.context = (ServletContext)Mockito.mock(ServletContext.class);
        this.request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        this.response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        this.recordServletRequest();
        return this;
    }

    private void recordServletRequest() {
        Mockito.when((Object)this.externalContext.getContext()).thenReturn((Object)this.context);
        Mockito.when((Object)this.externalContext.getRequest()).thenReturn((Object)this.request);
        Mockito.when((Object)this.externalContext.getResponse()).thenReturn((Object)this.response);
    }

    public MockFacesEnvironment withFactories() {
        FactoryFinder.releaseFactories();
        this.applicationFactory = this.setupAndEnhance(ApplicationFactory.class);
        this.facesContextFactory = this.setupAndEnhance(FacesContextFactory.class);
        this.renderKitFactory = this.setupAndEnhance(RenderKitFactory.class);
        this.lifecycleFactory = this.setupAndEnhance(LifecycleFactory.class);
        if (jsf2) {
            this.tagHandlerDelegateFactory = this.setupAndEnhance(TagHandlerDelegateFactory.class);
            this.exceptionHandlerFactory = this.setupAndEnhance(ExceptionHandlerFactory.class);
            this.partialViewContextFactory = this.setupAndEnhance(PartialViewContextFactory.class);
            this.externalContextFactory = this.setupAndEnhance(ExternalContextFactory.class);
        }
        this.withFactories = true;
        return this;
    }

    private <T> T setupAndEnhance(Class<T> type) {
        String factoryName = type.getName();
        FactoryMock<T> factoryMock = this.service.createFactoryMock(type);
        FactoryFinder.setFactory((String)factoryName, (String)factoryMock.getMockClassName());
        T mock = type.cast(FactoryFinder.getFactory((String)factoryName));
        this.service.enhance(factoryMock, mock);
        return mock;
    }

    public MockFacesEnvironment withApplication() {
        this.application = (Application)Mockito.mock(Application.class);
        this.viewHandler = (ViewHandler)Mockito.mock(ViewHandler.class);
        this.recordApplication();
        return this;
    }

    private void recordApplication() {
        Mockito.when((Object)this.facesContext.getApplication()).thenReturn((Object)this.application);
        Mockito.when((Object)this.application.getViewHandler()).thenReturn((Object)this.viewHandler);
    }

    public MockFacesEnvironment withRenderKit() {
        this.renderKit = (RenderKit)Mockito.mock(RenderKit.class);
        this.responseStateManager = (ResponseStateManager)Mockito.mock(ResponseStateManager.class);
        this.recordRenderKit();
        return this;
    }

    private void recordRenderKit() {
        Mockito.when((Object)this.facesContext.getRenderKit()).thenReturn((Object)this.renderKit);
        Mockito.when((Object)this.renderKit.getResponseStateManager()).thenReturn((Object)this.responseStateManager);
    }

    public MockFacesEnvironment withResponseWriter() {
        this.responseWriter = new RecordingResponseWriter("UTF-8", "text/html");
        this.recordResponseWriter();
        return this;
    }

    private void recordResponseWriter() {
        Mockito.when((Object)this.facesContext.getResponseWriter()).thenReturn((Object)this.responseWriter);
    }

    private void recordEnvironment() {
        if (null != this.externalContext) {
            this.recordExternalContext();
        }
        if (null != this.elContext) {
            this.recordELContext();
        }
        if (null != this.request) {
            this.recordServletRequest();
        }
        if (null != this.application) {
            this.recordApplication();
        }
        if (null != this.renderKit) {
            this.recordRenderKit();
        }
        if (null != this.responseWriter) {
            this.recordResponseWriter();
        }
        if (this.withFactories) {
            this.withFactories();
        }
    }

    public MockFacesEnvironment reset() {
        this.recordEnvironment();
        return this;
    }

    public void release() {
        this.facesContext.release();
        if (this.withFactories) {
            FactoryFinder.releaseFactories();
        }
    }

    public FacesContext getFacesContext() {
        return this.facesContext;
    }

    public ExternalContext getExternalContext() {
        return this.externalContext;
    }

    public ELContext getElContext() {
        return this.elContext;
    }

    public ServletContext getServletContext() {
        return this.context;
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public HttpServletResponse getResponse() {
        return this.response;
    }

    public Application getApplication() {
        return this.application;
    }

    public ViewHandler getViewHandler() {
        return this.viewHandler;
    }

    public RenderKit getRenderKit() {
        return this.renderKit;
    }

    public ResponseStateManager getResponseStateManager() {
        return this.responseStateManager;
    }

    public RecordingResponseWriter getResponseWriter() {
        return this.responseWriter;
    }

    public ApplicationFactory getApplicationFactory() {
        return this.applicationFactory;
    }

    public FacesContextFactory getFacesContextFactory() {
        return this.facesContextFactory;
    }

    public RenderKitFactory getRenderKitFactory() {
        return this.renderKitFactory;
    }

    public LifecycleFactory getLifecycleFactory() {
        return this.lifecycleFactory;
    }

    public TagHandlerDelegateFactory getTagHandlerDelegateFactory() {
        return this.tagHandlerDelegateFactory;
    }

    public ExceptionHandlerFactory getExceptionHandlerFactory() {
        return this.exceptionHandlerFactory;
    }

    public PartialViewContextFactory getPartialViewContextFactory() {
        return this.partialViewContextFactory;
    }

    public ExternalContextFactory getExternalContextFactory() {
        return this.externalContextFactory;
    }

    static {
        try {
            Class.forName("javax.faces.component.behavior.Behavior", false, FacesContext.class.getClassLoader());
            jsf2 = true;
        }
        catch (Throwable e) {
            jsf2 = false;
        }
    }
}

