/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.faces.mockito.runner;

import java.lang.reflect.Field;
import java.util.ArrayList;
import javax.el.ELContext;
import javax.faces.application.Application;
import javax.faces.application.ApplicationFactory;
import javax.faces.application.ViewHandler;
import javax.faces.context.ExceptionHandlerFactory;
import javax.faces.context.ExternalContext;
import javax.faces.context.ExternalContextFactory;
import javax.faces.context.FacesContext;
import javax.faces.context.FacesContextFactory;
import javax.faces.context.PartialViewContextFactory;
import javax.faces.lifecycle.LifecycleFactory;
import javax.faces.render.RenderKit;
import javax.faces.render.RenderKitFactory;
import javax.faces.render.ResponseStateManager;
import javax.faces.view.facelets.TagHandlerDelegateFactory;
import javax.inject.Inject;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jboss.test.faces.annotation.Environment;
import org.jboss.test.faces.mockito.MockFacesEnvironment;
import org.jboss.test.faces.writer.RecordingResponseWriter;
import org.junit.internal.runners.model.MultipleFailureException;
import org.junit.runner.notification.RunListener;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;
import org.mockito.MockitoAnnotations;
import org.mockito.internal.runners.util.FrameworkUsageValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FacesMockitoRunner
extends BlockJUnit4ClassRunner {
    private MockFacesEnvironment environment;

    public FacesMockitoRunner(Class<?> klass) throws InitializationError {
        super(klass);
    }

    public void run(RunNotifier notifier) {
        notifier.addListener((RunListener)new FrameworkUsageValidator(notifier));
        super.run(notifier);
    }

    protected Statement withBefores(FrameworkMethod method, final Object target, final Statement originalStatement) {
        final Statement onlyBefores = super.withBefores(method, target, (Statement)new EmptyStatement());
        return new Statement(){

            public void evaluate() throws Throwable {
                FacesMockitoRunner.this.runBefore(target);
                onlyBefores.evaluate();
                originalStatement.evaluate();
            }
        };
    }

    protected Statement withAfters(FrameworkMethod method, final Object target, final Statement originalStatement) {
        final Statement onlyAfters = super.withAfters(method, target, (Statement)new EmptyStatement());
        final Statement runnerAfters = new Statement(){

            public void evaluate() throws Throwable {
                FacesMockitoRunner.this.runAfter(target);
            }
        };
        return new Statement(){

            public void evaluate() throws Throwable {
                FacesMockitoRunner.this.multiExecute(new Statement[]{originalStatement, onlyAfters, runnerAfters});
            }
        };
    }

    protected void runBefore(Object target) {
        MockitoAnnotations.initMocks((Object)target);
        this.environment = new MockFacesEnvironment();
        this.processInjections(target);
        this.processFeatures(target);
    }

    protected void runAfter(Object target) {
        this.environment.release();
        this.environment = null;
    }

    private void processFeatures(Object target) {
        Environment annotation = target.getClass().getAnnotation(Environment.class);
        Environment.Feature[] features = annotation != null ? annotation.value() : Environment.Feature.values();
        for (Environment.Feature feature : features) {
            this.initializeFeature(feature);
        }
    }

    private void processInjections(Object target) {
        for (Field field : target.getClass().getDeclaredFields()) {
            Object injection;
            if (field.getAnnotation(Inject.class) == null || (injection = this.getInjection(field.getType())) == null) continue;
            this.inject(field, target, injection);
        }
    }

    private void inject(Field field, Object target, Object injection) {
        boolean accessible = field.isAccessible();
        if (!accessible) {
            field.setAccessible(true);
        }
        try {
            field.set(target, injection);
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot inject value to " + field, e);
        }
        if (!accessible) {
            field.setAccessible(false);
        }
    }

    private void initializeFeature(Environment.Feature feature) {
        switch (feature) {
            case FACTORIES: {
                this.environment.withFactories();
                break;
            }
            case APPLICATION: {
                this.environment.withApplication();
                break;
            }
            case EL_CONTEXT: {
                this.environment.withELContext();
                break;
            }
            case EXTERNAL_CONTEXT: {
                this.environment.withExternalContext();
                break;
            }
            case RENDER_KIT: {
                this.environment.withRenderKit();
                break;
            }
            case RESPONSE_WRITER: {
                this.environment.withResponseWriter();
                break;
            }
            case SERVLET_REQUEST: {
                this.environment.withServletRequest();
                break;
            }
        }
    }

    private Object getInjection(Class<?> type) {
        if (type == MockFacesEnvironment.class) {
            return this.environment;
        }
        if (type == FacesContext.class) {
            this.initializeFeature(Environment.Feature.FACES_CONTEXT);
            return this.environment.getFacesContext();
        }
        if (type == Application.class) {
            this.initializeFeature(Environment.Feature.APPLICATION);
            return this.environment.getApplication();
        }
        if (type == ELContext.class) {
            this.initializeFeature(Environment.Feature.EL_CONTEXT);
            return this.environment.getElContext();
        }
        if (type == ApplicationFactory.class) {
            this.initializeFeature(Environment.Feature.FACTORIES);
            return this.environment.getApplicationFactory();
        }
        if (type == ServletContext.class) {
            this.initializeFeature(Environment.Feature.SERVLET_REQUEST);
            return this.environment.getServletContext();
        }
        if (type == ExceptionHandlerFactory.class) {
            this.initializeFeature(Environment.Feature.FACTORIES);
            return this.environment.getExceptionHandlerFactory();
        }
        if (type == ExternalContext.class) {
            this.initializeFeature(Environment.Feature.EXTERNAL_CONTEXT);
            return this.environment.getExternalContext();
        }
        if (type == ExternalContextFactory.class) {
            this.initializeFeature(Environment.Feature.FACTORIES);
            return this.environment.getExternalContextFactory();
        }
        if (type == FacesContextFactory.class) {
            this.initializeFeature(Environment.Feature.FACTORIES);
            return this.environment.getFacesContextFactory();
        }
        if (type == LifecycleFactory.class) {
            this.initializeFeature(Environment.Feature.FACTORIES);
            return this.environment.getLifecycleFactory();
        }
        if (type == PartialViewContextFactory.class) {
            this.initializeFeature(Environment.Feature.FACTORIES);
            return this.environment.getPartialViewContextFactory();
        }
        if (type == RenderKit.class) {
            this.initializeFeature(Environment.Feature.RENDER_KIT);
            return this.environment.getRenderKit();
        }
        if (type == RenderKitFactory.class) {
            this.initializeFeature(Environment.Feature.FACTORIES);
            return this.environment.getRenderKitFactory();
        }
        if (type == HttpServletRequest.class) {
            this.initializeFeature(Environment.Feature.SERVLET_REQUEST);
            return this.environment.getRequest();
        }
        if (type == HttpServletResponse.class) {
            this.initializeFeature(Environment.Feature.SERVLET_REQUEST);
            return this.environment.getResponse();
        }
        if (type == ResponseStateManager.class) {
            this.initializeFeature(Environment.Feature.RENDER_KIT);
            return this.environment.getResponseStateManager();
        }
        if (RecordingResponseWriter.class.isAssignableFrom(type)) {
            this.initializeFeature(Environment.Feature.RESPONSE_WRITER);
            return this.environment.getResponseWriter();
        }
        if (type == TagHandlerDelegateFactory.class) {
            this.initializeFeature(Environment.Feature.FACTORIES);
            return this.environment.getTagHandlerDelegateFactory();
        }
        if (type == ViewHandler.class) {
            this.initializeFeature(Environment.Feature.APPLICATION);
            return this.environment.getViewHandler();
        }
        return null;
    }

    private void multiExecute(Statement ... statements) throws Throwable {
        ArrayList<Exception> exceptions = new ArrayList<Exception>();
        for (Statement command : statements) {
            try {
                command.evaluate();
            }
            catch (Exception e) {
                exceptions.add(e);
            }
        }
        if (exceptions.isEmpty()) {
            return;
        }
        if (exceptions.size() == 1) {
            throw (Throwable)exceptions.get(0);
        }
        throw new MultipleFailureException(exceptions);
    }

    private static class EmptyStatement
    extends Statement {
        private EmptyStatement() {
        }

        public void evaluate() throws Throwable {
        }
    }
}

