/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.faces.mockito.component;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import org.jboss.test.faces.mockito.component.Facet;
import org.jboss.test.faces.mockito.component.TreeBuilder;
import org.jboss.test.faces.mockito.component.TreeVisitor;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public class TreeBuilderImpl<C extends UIComponent>
implements TreeBuilder<C> {
    private final C component;
    private final List<TreeBuilder<?>> childrenBuilders;
    private final List<UIComponent> children;
    private final Map<String, UIComponent> facets;

    protected TreeBuilderImpl(C component) {
        this.component = component;
        this.childrenBuilders = new ArrayList();
        this.children = new ArrayList<UIComponent>();
        this.facets = new HashMap<String, UIComponent>();
        Mockito.when((Object)component.getChildren()).thenReturn(this.children);
        Mockito.when((Object)component.getFacets()).thenReturn(this.facets);
        Mockito.when((Object)component.getChildCount()).thenAnswer((Answer)new Answer<Integer>(){

            public Integer answer(InvocationOnMock invocation) throws Throwable {
                return TreeBuilderImpl.this.children.size();
            }
        });
        final ArgumentCaptor argument = ArgumentCaptor.forClass(String.class);
        Mockito.when((Object)component.getFacet((String)argument.capture())).thenAnswer((Answer)new Answer<UIComponent>(){

            public UIComponent answer(InvocationOnMock invocation) throws Throwable {
                return (UIComponent)TreeBuilderImpl.this.facets.get(argument.getValue());
            }
        });
        Mockito.when((Object)component.getFacetCount()).thenAnswer((Answer)new Answer<Integer>(){

            public Integer answer(InvocationOnMock invocation) throws Throwable {
                return TreeBuilderImpl.this.facets.size();
            }
        });
        Mockito.when((Object)component.getFacetsAndChildren()).thenAnswer((Answer)new Answer<Iterator<UIComponent>>(){

            public Iterator<UIComponent> answer(InvocationOnMock invocation) throws Throwable {
                ArrayList facetsAndChildren = new ArrayList(TreeBuilderImpl.this.facets.values());
                facetsAndChildren.addAll(TreeBuilderImpl.this.children);
                return facetsAndChildren.iterator();
            }
        });
    }

    @Override
    public TreeBuilder<C> id(String id) {
        Mockito.when((Object)this.component.getId()).thenReturn((Object)id);
        return this;
    }

    @Override
    public void visitTree(TreeVisitor visitor) {
        visitor.visit(this);
        for (TreeBuilder<?> child : this.childrenBuilders) {
            child.visitTree(visitor);
        }
    }

    @Override
    public C getComponent() {
        return this.component;
    }

    @Override
    public TreeBuilder<C> children(TreeBuilder<?> ... builders) {
        for (TreeBuilder<?> treeBuilder : builders) {
            this.children.add((UIComponent)treeBuilder.getComponent());
            this.addChildBuilder(treeBuilder);
        }
        return this;
    }

    private void addChildBuilder(TreeBuilder<?> treeBuilder) {
        this.childrenBuilders.add(treeBuilder);
        Mockito.when((Object)treeBuilder.getComponent().getParent()).thenReturn(this.component);
    }

    @Override
    public TreeBuilder<C> facets(Facet<?> ... facets) {
        for (Facet<?> facet : facets) {
            this.facets.put(facet.getName(), (UIComponent)facet.getBuilder().getComponent());
            this.addChildBuilder(facet.getBuilder());
        }
        return null;
    }
}

