/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.faces.jetty;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.jboss.test.faces.ApplicationServer;
import org.jboss.test.faces.FilterHolder;
import org.jboss.test.faces.ServletHolder;
import org.jboss.test.faces.TestException;
import org.jboss.test.faces.jetty.StringContentResource;
import org.jboss.test.faces.jetty.VirtualDirectoryResource;
import org.jboss.test.faces.staging.HttpConnection;
import org.jboss.test.faces.staging.ServerResourcePath;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.handler.DefaultHandler;
import org.mortbay.jetty.handler.HandlerList;
import org.mortbay.jetty.servlet.DefaultServlet;
import org.mortbay.jetty.webapp.WebAppContext;
import org.mortbay.resource.Resource;

public class JettyServer
extends ApplicationServer {
    private static final String WEB_XML = "/WEB-INF/web.xml";
    private static final String DUMMY_WEB_XML = "org/jboss/test/faces/jetty/dummy/web.xml";
    private static final int DEFAULT_PORT = 8880;
    private int port;
    private Server server;
    private WebAppContext webAppContext;
    private VirtualDirectoryResource serverRoot = new VirtualDirectoryResource("");
    private HttpSession session;

    public JettyServer() {
        this(8880);
    }

    public JettyServer(int port) {
        this.port = port;
        this.createContext();
    }

    private ClassLoader getClassLoader() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = ((Object)((Object)this)).getClass().getClassLoader();
        }
        return classLoader;
    }

    private void createContext() {
        this.webAppContext = new WebAppContext();
        this.webAppContext.setContextPath("/");
        this.webAppContext.setBaseResource((Resource)this.serverRoot);
        this.webAppContext.setClassLoader(this.getClassLoader());
        org.mortbay.jetty.servlet.ServletHolder defaultServletHolder = new org.mortbay.jetty.servlet.ServletHolder((Servlet)new DefaultServlet());
        this.webAppContext.addServlet(defaultServletHolder, "/");
        this.webAppContext.addEventListener((EventListener)new HttpSessionListener(){

            public void sessionDestroyed(HttpSessionEvent se) {
                JettyServer.this.session = null;
            }

            public void sessionCreated(HttpSessionEvent se) {
                JettyServer.this.session = se.getSession();
            }
        });
    }

    private boolean isClassAvailable(String elFactoryClass) {
        try {
            Class.forName(elFactoryClass);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public void init() {
        this.server = new Server(this.port);
        HandlerList handlers = new HandlerList();
        handlers.setHandlers(new Handler[]{this.webAppContext, new DefaultHandler()});
        this.server.setHandler((Handler)handlers);
        if (this.isClassAvailable("com.sun.el.ExpressionFactoryImpl")) {
            this.addInitParameter("com.sun.faces.expressionFactory", "com.sun.el.ExpressionFactoryImpl");
        } else if (this.isClassAvailable("org.jboss.el.ExpressionFactoryImpl")) {
            this.addInitParameter("com.sun.faces.expressionFactory", "org.jboss.el.ExpressionFactoryImpl");
        }
        try {
            Resource webXml = this.webAppContext.getResource(WEB_XML);
            if (webXml == null || !webXml.exists()) {
                URL dummyWebXml = this.webAppContext.getClassLoader().getResource(DUMMY_WEB_XML);
                this.addResource(WEB_XML, dummyWebXml);
            }
        }
        catch (MalformedURLException e1) {
            // empty catch block
        }
        try {
            this.server.start();
            this.server.setStopAtShutdown(true);
        }
        catch (Exception e) {
            throw new TestException(e.getMessage(), (Throwable)e);
        }
    }

    public void destroy() {
        try {
            this.server.stop();
            this.server.setStopAtShutdown(false);
            this.server.destroy();
        }
        catch (Exception e) {
            throw new TestException(e.getMessage(), (Throwable)e);
        }
        finally {
            this.session = null;
            this.server = null;
        }
    }

    public void addInitParameter(String name, String value) {
        this.webAppContext.getInitParams().put(name, value);
    }

    public void addWebListener(EventListener listener) {
        this.webAppContext.addEventListener(listener);
    }

    public ServletContext getContext() {
        if (!this.webAppContext.isStarted()) {
            throw new IllegalStateException("Server should be started before getContext() can be called!");
        }
        return this.webAppContext.getServletContext();
    }

    public void addMimeType(String extension, String mimeType) {
        this.webAppContext.getMimeTypes().addMimeMapping(extension, mimeType);
    }

    public void addContent(String path, String content) {
        this.serverRoot.addResource(path, new StringContentResource(content, path));
    }

    public void addResource(String path, String resource) {
        this.serverRoot.addResource(path, Resource.newClassPathResource((String)resource));
    }

    public void addResource(String path, URL resource) {
        try {
            this.serverRoot.addResource(path, Resource.newResource((URL)resource));
        }
        catch (IOException e) {
            throw new TestException(e.getMessage(), (Throwable)e);
        }
    }

    public void addFilter(FilterHolder filerHolder) {
        Map initParameters = filerHolder.getInitParameters();
        String mapping = filerHolder.getMapping();
        String name = filerHolder.getName();
        Filter filter = filerHolder.getFilter();
        org.mortbay.jetty.servlet.FilterHolder jettyFilterHolder = new org.mortbay.jetty.servlet.FilterHolder(filter);
        jettyFilterHolder.setName(name);
        jettyFilterHolder.setInitParameters(initParameters);
        this.webAppContext.addFilter(jettyFilterHolder, mapping, 15);
    }

    public void addServlet(ServletHolder servletHolder) {
        Map initParameters = servletHolder.getInitParameters();
        String mapping = servletHolder.getMapping();
        String name = servletHolder.getName();
        Servlet servlet = servletHolder.getServlet();
        org.mortbay.jetty.servlet.ServletHolder jettyServletHolder = new org.mortbay.jetty.servlet.ServletHolder(servlet);
        jettyServletHolder.setName(name);
        jettyServletHolder.setInitParameters(initParameters);
        this.webAppContext.addServlet(jettyServletHolder, mapping);
    }

    public int getPort() {
        return this.port;
    }

    public HttpConnection getConnection(URL url) {
        return new JettyConnection(url);
    }

    public HttpSession getSession() {
        return this.getSession(true);
    }

    public HttpSession getSession(boolean create) {
        if (this.session == null && create) {
            throw new UnsupportedOperationException("Session creation is not supported by JettyServer");
        }
        return this.session;
    }

    public boolean isSessionPerThread() {
        return false;
    }

    public void setSessionPerThread(boolean sessionPerThread) {
    }

    protected void addDirectory(String directoryPath) {
        this.serverRoot.createChildDirectory(new ServerResourcePath(directoryPath));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class JettyConnection
    extends HttpConnection {
        private final URL url;
        private String requestContentType;
        private String requestEncoding = "UTF-8";
        private String requestBody;
        private final HttpClient client;
        private HttpMethodBase httpClientMethod;
        private int statusCode;
        private Map<String, String> requestHeaders = new HashMap<String, String>();

        public JettyConnection(URL url) {
            this.client = new HttpClient();
            this.url = url;
        }

        public void start() {
            throw new UnsupportedOperationException("Jetty server does not allow in-process requests");
        }

        public void setRequestContentType(String contentType) {
            this.requestContentType = contentType;
        }

        public void setRequestCharacterEncoding(String charset) throws UnsupportedEncodingException {
            this.requestEncoding = charset;
        }

        public void setRequestBody(String body) {
            this.requestBody = body;
        }

        public boolean isStarted() {
            return null != this.httpClientMethod;
        }

        public boolean isFinished() {
            return null != this.httpClientMethod && this.httpClientMethod.isRequestSent();
        }

        public int getResponseStatus() {
            return this.statusCode;
        }

        public Map<String, String[]> getResponseHeaders() {
            Header[] headers = this.httpClientMethod.getResponseHeaders();
            HashMap<String, String[]> map = new HashMap<String, String[]>(headers.length);
            for (Header header : headers) {
                map.put(header.getName(), new String[]{header.getValue()});
            }
            return map;
        }

        public String getResponseContentType() {
            Header responseHeader = this.httpClientMethod.getResponseHeader("Content-Type");
            return null != responseHeader ? responseHeader.getValue() : null;
        }

        public long getResponseContentLength() {
            return this.httpClientMethod.getResponseContentLength();
        }

        public String getResponseCharacterEncoding() {
            return this.httpClientMethod.getResponseCharSet();
        }

        public byte[] getResponseBody() {
            try {
                return this.httpClientMethod.getResponseBody();
            }
            catch (IOException e) {
                throw new TestException((Throwable)e);
            }
        }

        public HttpServletResponse getResponse() {
            throw new UnsupportedOperationException("Jetty server does not allow in-process requests");
        }

        public HttpServletRequest getRequest() {
            throw new UnsupportedOperationException("Jetty server does not allow in-process requests");
        }

        public String getErrorMessage() {
            return this.httpClientMethod.getStatusText();
        }

        public String getContentAsString() {
            try {
                return this.httpClientMethod.getResponseBodyAsString();
            }
            catch (IOException e) {
                throw new TestException((Throwable)e);
            }
        }

        public void finish() {
            if (null != this.httpClientMethod) {
                this.httpClientMethod.releaseConnection();
            }
        }

        public void execute() {
            switch (this.getRequestMethod()) {
                case GET: {
                    this.httpClientMethod = new GetMethod(this.url.toExternalForm());
                    break;
                }
                case POST: {
                    PostMethod postMethod = new PostMethod(this.url.toExternalForm());
                    if (null != this.requestBody) {
                        try {
                            StringRequestEntity body = new StringRequestEntity(this.requestBody, this.requestContentType, this.requestEncoding);
                            postMethod.setRequestEntity((RequestEntity)body);
                        }
                        catch (UnsupportedEncodingException e) {
                            throw new TestException((Throwable)e);
                        }
                    }
                    this.httpClientMethod = postMethod;
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Http Method " + this.getRequestMethod() + " is not supported");
                }
            }
            String queryString = this.getRequestQueryString();
            try {
                if (null != queryString) {
                    this.httpClientMethod.setQueryString(queryString);
                }
                for (Map.Entry<String, String> entry : this.requestHeaders.entrySet()) {
                    this.httpClientMethod.addRequestHeader(entry.getKey(), entry.getValue());
                }
                this.statusCode = this.client.executeMethod((HttpMethod)this.httpClientMethod);
            }
            catch (IOException e) {
                throw new TestException((Throwable)e);
            }
        }

        public void addRequestHeaders(Map<String, String> headers) {
            this.requestHeaders.putAll(headers);
        }

        protected String getRequestCharacterEncoding() {
            return this.requestEncoding;
        }
    }
}

