/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.faces.jetty;

import java.io.IOException;
import java.net.MalformedURLException;
import org.jboss.test.faces.TestException;
import org.jboss.test.faces.jetty.VirtualDirectoryResource;
import org.jboss.test.faces.staging.DirectoryMapAdapter;
import org.jboss.test.faces.staging.ServerResourcePath;
import org.mortbay.resource.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JettyDirectoryMapAdapter
implements DirectoryMapAdapter<Resource, VirtualDirectoryResource> {
    static final DirectoryMapAdapter<Resource, VirtualDirectoryResource> INSTANCE = new JettyDirectoryMapAdapter();

    private JettyDirectoryMapAdapter() {
    }

    public void addResource(VirtualDirectoryResource resource, ServerResourcePath path, Resource childResource) {
        resource.addResource(path.toString(), childResource);
    }

    public VirtualDirectoryResource asDirectory(Resource resource) {
        if (resource instanceof VirtualDirectoryResource) {
            return (VirtualDirectoryResource)resource;
        }
        return null;
    }

    public Resource getResource(Resource resource, ServerResourcePath path) {
        try {
            return resource.addPath(path.toString());
        }
        catch (MalformedURLException e) {
            throw new TestException(e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            throw new TestException(e.getMessage(), (Throwable)e);
        }
    }

    public VirtualDirectoryResource addDirectory(VirtualDirectoryResource directory, String name) {
        return directory.createChildDirectory(name);
    }

    public VirtualDirectoryResource createChildDirectory(String path) {
        return new VirtualDirectoryResource(path);
    }

    public String getResourcePath(Resource resource) {
        return resource.getName();
    }
}

