/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mockgenerator;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.jboss.mockgenerator.MockControlSource;
import org.jboss.mockgenerator.MockJavaSource;
import org.jboss.mockgenerator.config.Mock;
import org.jboss.mockgenerator.config.MockConfig;
import org.jboss.mockgenerator.config.MockMethod;
import org.jboss.mockgenerator.config.io.xpp3.MockConfigXpp3Reader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMockMojo
extends AbstractMojo {
    protected MavenProject project;
    protected File outputDirectory;
    protected ClassLoader projectClassLoader;
    protected MockConfig mockConfig;
    protected int errorsCount = 0;
    private static final List<String> requiredSystemMethods = Arrays.asList("toString", "equals", "hashCode");
    private static final List<String> systemMethods = Arrays.asList("getClass", "wait", "notify", "notifyAll");

    public void execute() throws MojoExecutionException {
        File f = this.getOutputJavaDirectory();
        if (!f.exists()) {
            f.mkdirs();
        }
        this.mockConfig = this.readConfig();
        this.projectClassLoader = this.createProjectClassLoader();
        MockControlSource mockControl = new MockControlSource(this.getOutputJavaDirectory(), this.mockConfig.getMockController());
        mockControl.printFileHeader();
        for (Mock mock : this.mockConfig.getMocks()) {
            this.generateClass(mock);
            mockControl.printMockClass(mock.getName());
        }
        if (this.errorsCount > 0) {
            throw new MojoExecutionException("Errors during mock classes grneration");
        }
        mockControl.printFileFooter();
        try {
            mockControl.writeClassFile();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error writing mock controller Java source", (Exception)e);
        }
        this.addGeneratedSourcesToProject();
    }

    protected abstract void addGeneratedSourcesToProject();

    protected abstract File getOutputJavaDirectory();

    protected abstract File getConfig();

    protected abstract Collection<String> getClasspathElements();

    protected void generateClass(Mock mock) throws MojoExecutionException {
        try {
            String className = mock.getClassName();
            Class<?> baseClass = this.projectClassLoader.loadClass(className);
            String mockClassName = mock.getName();
            if (null == mockClassName || mockClassName.length() == 0) {
                int indexOfDot = className.lastIndexOf(46);
                mockClassName = this.mockConfig.getMockPackage() + "." + this.mockConfig.getClassPrefix() + className.substring(indexOfDot + 1);
                mock.setName(mockClassName);
            }
            MockJavaSource javaSource = new MockJavaSource(this.getOutputJavaDirectory(), mockClassName, className, this.mockConfig.getMockController());
            javaSource.printFileHeader(mock.getPostConstruct());
            List<Method> declaredMethods = this.getPublicMethods(baseClass);
            for (Method method : declaredMethods) {
                String name = method.getName();
                if (this.skipMethod(mock, name)) continue;
                javaSource.printMethod(method);
            }
            javaSource.printFileFooter(mock.getCode());
            javaSource.writeClassFile();
        }
        catch (ClassNotFoundException e) {
            this.getLog().error((CharSequence)"Base class for Mock not found", (Throwable)e);
            ++this.errorsCount;
        }
        catch (IOException e) {
            this.getLog().error((CharSequence)"Error writing Mock class source", (Throwable)e);
            ++this.errorsCount;
        }
    }

    protected List<Method> getPublicMethods(Class<?> baseClass) {
        Method[] declaredMethods = baseClass.getMethods();
        LinkedList<Method> publicMethods = new LinkedList<Method>();
        for (Method method : declaredMethods) {
            ArrayList<Method> overridenPublicMethods = new ArrayList<Method>();
            boolean visible = true;
            int modifiers = method.getModifiers();
            if (requiredSystemMethods.contains(method.getName()) || systemMethods.contains(method.getName()) && 0 == (modifiers & 0x400) || 0 != (modifiers & 0x18)) {
                visible = false;
            } else {
                for (Method otherMethod : publicMethods) {
                    Object[] otherMethodParameters;
                    Object[] methodParameters;
                    if (!method.getName().equals(otherMethod.getName()) || method == otherMethod || !Arrays.equals(methodParameters = method.getParameterTypes(), otherMethodParameters = otherMethod.getParameterTypes())) continue;
                    if (method.getDeclaringClass().isAssignableFrom(otherMethod.getDeclaringClass())) {
                        if (!method.getDeclaringClass().equals(otherMethod.getDeclaringClass())) {
                            visible = false;
                            break;
                        }
                        if (method.getReturnType().isAssignableFrom(otherMethod.getReturnType())) {
                            visible = false;
                            break;
                        }
                        overridenPublicMethods.add(otherMethod);
                        continue;
                    }
                    overridenPublicMethods.add(otherMethod);
                }
            }
            publicMethods.removeAll(overridenPublicMethods);
            if (!visible) continue;
            publicMethods.add(method);
        }
        return publicMethods;
    }

    protected boolean skipMethod(Mock mock, String name) {
        for (MockMethod mockMethod : mock.getMethods()) {
            if (!name.equals(mockMethod.getName()) || !mockMethod.isExclude()) continue;
            return true;
        }
        return false;
    }

    protected ClassLoader createProjectClassLoader() {
        URLClassLoader classLoader = null;
        try {
            Collection<String> classpathElements = this.getClasspathElements();
            String outputDirectory = this.project.getBuild().getOutputDirectory();
            URL[] urls = new URL[classpathElements.size() + 1];
            int i = 0;
            urls[i++] = new File(outputDirectory).toURI().toURL();
            for (String element : classpathElements) {
                urls[i++] = new File(element).toURI().toURL();
            }
            classLoader = new URLClassLoader(urls);
        }
        catch (MalformedURLException e) {
            this.getLog().error((CharSequence)"Bad URL in classpath", (Throwable)e);
        }
        return classLoader;
    }

    protected MockConfig readConfig() throws MojoExecutionException {
        FileInputStream configurationInput = null;
        try {
            MockConfig mockConfig;
            MockConfigXpp3Reader reader = new MockConfigXpp3Reader();
            configurationInput = new FileInputStream(this.getConfig());
            MockConfig mockConfig2 = mockConfig = reader.read(configurationInput);
            return mockConfig2;
        }
        catch (FileNotFoundException e) {
            throw new MojoExecutionException("Configuration file does not exists:" + this.getConfig().getAbsolutePath());
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error readind configuration file: " + this.getConfig().getAbsolutePath(), (Exception)e);
        }
        catch (XmlPullParserException e) {
            throw new MojoExecutionException("Error parsing configuration file: " + this.getConfig().getAbsolutePath(), (Exception)((Object)e));
        }
        finally {
            if (null != configurationInput) {
                try {
                    configurationInput.close();
                }
                catch (IOException e) {}
            }
        }
    }
}

