/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.clusterbench.common.session;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.jboss.test.clusterbench.common.SerialBean;

public class CommonGranularHttpSessionServlet
extends HttpServlet {
    private static final Logger log = Logger.getLogger(CommonGranularHttpSessionServlet.class.getName());
    public static final String KEY_SERIAL = CommonGranularHttpSessionServlet.class.getName() + "Serial";
    public static final String KEY_CARGO = CommonGranularHttpSessionServlet.class.getName() + "Cargo";

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        HttpSession session = req.getSession(true);
        if (session.isNew()) {
            log.log(Level.INFO, "New session created: {0}", session.getId());
            SerialBean tempBean = new SerialBean();
            session.setAttribute(KEY_SERIAL, (Object)tempBean.getSerial());
            this.storeCargo(session, tempBean.getCargo());
        }
        Integer serial = (Integer)session.getAttribute(KEY_SERIAL);
        byte[] cargo = this.loadCargo(session);
        resp.setContentType("text/plain");
        if (req.getParameter("readonly") != null) {
            resp.getWriter().print(serial);
            return;
        }
        session.setAttribute(KEY_SERIAL, (Object)(serial + 1));
        resp.getWriter().print(serial);
        if (req.getParameter("invalidate") != null) {
            log.log(Level.INFO, "Invalidating: {0}", session.getId());
            session.invalidate();
        }
    }

    public void storeCargo(HttpSession session, byte[] cargo) {
        session.setAttribute(KEY_CARGO, (Object)cargo);
    }

    public byte[] loadCargo(HttpSession session) {
        return (byte[])session.getAttribute(KEY_CARGO);
    }

    public String getServletInfo() {
        return "Servlet using HTTP Session attributes to store serial and cargo separately.";
    }
}

