/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.clusterbench.web.granular;

import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpSession;
import java.io.Serializable;
import org.jboss.test.clusterbench.common.session.CommonGranularHttpSessionServlet;
import org.wildfly.clustering.web.annotation.Immutable;

@WebServlet(name="GranularSessionServlet", urlPatterns={"/granular"})
public class GranularHttpSessionServlet
extends CommonGranularHttpSessionServlet {
    public void storeCargo(HttpSession session, byte[] cargo) {
        ImmutableWrapper<byte[]> wrap = new ImmutableWrapper<byte[]>(cargo);
        session.setAttribute(KEY_CARGO, wrap);
    }

    public byte[] loadCargo(HttpSession session) {
        ImmutableWrapper wrap = (ImmutableWrapper)session.getAttribute(KEY_CARGO);
        return (byte[])wrap.getValue();
    }

    @Immutable
    static class ImmutableWrapper<T>
    implements Serializable {
        private final T value;

        ImmutableWrapper(T value) {
            this.value = value;
        }

        T getValue() {
            return this.value;
        }
    }
}

