/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.clusterbench.web.cdi;

import jakarta.inject.Inject;
import jakarta.servlet.ServletException;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.test.clusterbench.web.cdi.SessionScopedCdiSerialBean;

@WebServlet(name="CdiServlet", urlPatterns={"/cdi"})
public class CdiServlet
extends HttpServlet {
    @Inject
    private SessionScopedCdiSerialBean bean;
    private static final Logger log = Logger.getLogger(CdiServlet.class.getName());

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        resp.setContentType("text/plain");
        int serial = this.bean.getSerial();
        if (req.getParameter("readonly") != null) {
            resp.getWriter().print(this.bean.getSerial());
            return;
        }
        this.bean.setSerial(serial + 1);
        resp.getWriter().print(serial);
        if (req.getParameter("invalidate") != null) {
            HttpSession session = req.getSession(true);
            log.log(Level.INFO, "Invalidating: {0}", session.getId());
            session.invalidate();
        }
    }

    public String getServletInfo() {
        return "Servlet using CDI bean to store serial.";
    }
}

