/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.clusterbench.web.debug;

import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

@WebServlet(name="LoggerServlet", urlPatterns={"/log"})
public class LoggerServlet
extends HttpServlet {
    public static final String MESSAGE_PARAM = "msg";
    public static final String DEFAULT_MESSAGE = "ping";
    public static final String LEVEL_PARAM = "level";
    public static final Level DEFAULT_LEVEL = Level.INFO;
    private static final Logger LOG = Logger.getLogger(LoggerServlet.class.getCanonicalName());

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String requestLevel = request.getParameter(LEVEL_PARAM);
        String message = request.getParameter(MESSAGE_PARAM);
        Level level = null;
        if (requestLevel != null) {
            try {
                level = Level.parse(requestLevel);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        LOG.log(level == null ? DEFAULT_LEVEL : level, message == null ? DEFAULT_MESSAGE : message);
        response.getWriter().print("Success");
    }
}

