/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.clusterbench.web.load;

import jakarta.servlet.ServletException;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.logging.Logger;
import org.jboss.test.clusterbench.common.load.MemoryUsageStress;

@WebServlet(name="MemoryUsageServlet", urlPatterns={"/memoryusage"})
public class MemoryUsageServlet
extends HttpServlet {
    private static final long serialVersionUID = -3449582182280915069L;
    private static final Logger log = Logger.getLogger(MemoryUsageServlet.class.getName());
    private final MemoryUsageStress memoryUsageStress = new MemoryUsageStress();

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        int milliseconds = Integer.parseInt(request.getParameter("milliseconds"));
        int megabytes = Integer.parseInt(request.getParameter("megabytes"));
        response.setContentType("text/plain");
        response.setCharacterEncoding("UTF-8");
        response.getWriter().print(this.memoryUsageStress.stressSystemMemory(megabytes, milliseconds));
    }

    public String getServletInfo() {
        return "By invoking MemoryUsageStress, you stress JVM memory up to a set percentage of maxMemory.";
    }
}

