/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.clusterbench.common.load;

import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.AttributeNotFoundException;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class MemoryUsageStress {
    private static final Logger log = Logger.getLogger(MemoryUsageStress.class.getName());
    private static final String FREE_MEMORY_SIZE = "FreePhysicalMemorySize";
    private static final String TOTAL_MEMORY_SIZE = "TotalPhysicalMemorySize";
    private MBeanServer server = ManagementFactory.getPlatformMBeanServer();
    private ObjectName osMXBeanObjectName;
    private MemoryMXBean memBean = ManagementFactory.getMemoryMXBean();

    public MemoryUsageStress() {
        try {
            this.osMXBeanObjectName = ObjectName.getInstance("java.lang:type=OperatingSystem");
        }
        catch (MalformedObjectNameException e) {
            log.log(Level.SEVERE, "Can't work with OPERATING_SYSTEM_MXBEAN_NAME", e);
        }
    }

    public String stressSystemMemory(int megabytes, int milliseconds) {
        try {
            long started = System.currentTimeMillis();
            String before = this.getStats();
            log.log(Level.INFO, "\nBEFORE:" + before);
            byte[] rubbish = new byte[0x100000 * megabytes];
            Thread.sleep(milliseconds);
            rubbish = null;
            String after = this.getStats();
            log.log(Level.INFO, "\nAFTER: " + after);
            return "BEFORE:" + before + "\n AFTER:" + after + "\nDuration (including warm-up): " + (System.currentTimeMillis() - started) + " milliseconds";
        }
        catch (JMException e) {
            log.log(Level.SEVERE, "Can't work with OS MXBEAN", e);
        }
        catch (InterruptedException e) {
            log.log(Level.SEVERE, "Thread sleep has been interrupted.", e);
        }
        return "";
    }

    private <T> T getAttribute(String attribute, Class<T> targetClass) throws JMException {
        return targetClass.cast(this.server.getAttribute(this.osMXBeanObjectName, attribute));
    }

    public long getFreePhysical() throws JMException {
        return ((Number)this.getAttribute(FREE_MEMORY_SIZE, Number.class)).longValue();
    }

    public long getTotalPhysical() throws JMException {
        return ((Number)this.getAttribute(TOTAL_MEMORY_SIZE, Number.class)).longValue();
    }

    public MemoryUsage getHeapMem() {
        return this.memBean.getHeapMemoryUsage();
    }

    public MemoryUsage getNonHeapMem() {
        return this.memBean.getNonHeapMemoryUsage();
    }

    public String getStats() throws JMException {
        int runtimeTotal = (int)(Runtime.getRuntime().totalMemory() / 1024L / 1024L);
        int runtimeFree = (int)(Runtime.getRuntime().freeMemory() / 1024L / 1024L);
        int runtimeMax = (int)(Runtime.getRuntime().maxMemory() / 1024L / 1024L);
        int runtimePercent = runtimeMax != 0 ? runtimeTotal / (runtimeMax / 100) : -1;
        int heapInt = (int)(this.getHeapMem().getInit() / 1024L / 1024L);
        int heapUsed = (int)(this.getHeapMem().getUsed() / 1024L / 1024L);
        int heapCommitted = (int)(this.getHeapMem().getCommitted() / 1024L / 1024L);
        int heapMax = (int)(this.getHeapMem().getMax() / 1024L / 1024L);
        int heapUsedOfMax = heapMax != 0 ? heapUsed / (heapMax / 100) : -1;
        int nonHeapInt = (int)(this.getNonHeapMem().getInit() / 1024L / 1024L);
        int nonHeapUsed = (int)(this.getNonHeapMem().getUsed() / 1024L / 1024L);
        int nonHeapCommitted = (int)(this.getNonHeapMem().getCommitted() / 1024L / 1024L);
        int nonHeapMax = (int)(this.getNonHeapMem().getMax() / 1024L / 1024L);
        int nonHeapUsedOfMax = nonHeapMax / 100 != 0 ? nonHeapUsed / (nonHeapMax / 100) : -1;
        String heap = String.format("Heap:     INIT: %dMB, USED: %dMB, COMMITTED: %dMB, MAX: %dMB, UsedOfMax: %d%%\n", heapInt, heapUsed, heapCommitted, heapMax, heapUsedOfMax);
        String nonHeap = String.format("NonHeap:  INIT: %dMB, USED: %dMB, COMMITTED: %dMB, MAX: %dMB, UsedOfMax: %d%%", nonHeapInt, nonHeapUsed, nonHeapCommitted, nonHeapMax, nonHeapUsedOfMax);
        String physicalAndRuntime = null;
        try {
            long total = this.getTotalPhysical();
            long totalMB = total / 1024L / 1024L;
            long free = this.getFreePhysical();
            long freeMB = free / 1024L / 1024L;
            int physPercent = total != 0L ? (int)(free / (total / 100L)) : -1;
            physicalAndRuntime = String.format("Physical: TOTAL: %dMB, FREE: %dMB (%d%%)\nRuntime:  TOTAL: %dMB, FREE: %dMB, MAX: %dMB, TotalOfMax: %d%%\n", totalMB, freeMB, physPercent, runtimeTotal, runtimeFree, runtimeMax, runtimePercent);
        }
        catch (AttributeNotFoundException ex) {
            return heap + nonHeap;
        }
        return physicalAndRuntime + heap + nonHeap;
    }
}

