/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.clusterbench.common.debug;

import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.test.clusterbench.common.SerialBean;

public abstract class AbstractCommonDebugServlet
extends HttpServlet {
    private static final Logger log = Logger.getLogger(AbstractCommonDebugServlet.class.getName());
    public static final String KEY = AbstractCommonDebugServlet.class.getName();

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        HttpSession session = req.getSession(true);
        resp.setContentType("text/plain");
        resp.setCharacterEncoding(StandardCharsets.UTF_8.name());
        PrintWriter out = resp.getWriter();
        if (session.isNew()) {
            log.log(Level.INFO, "New session created: {0}", session.getId());
            session.setAttribute(KEY, (Object)new SerialBean());
        } else if (session.getAttribute(KEY) == null) {
            log.log(Level.INFO, "Session is not new, creating SerialBean: {0}", session.getId());
            session.setAttribute(KEY, (Object)new SerialBean());
        }
        SerialBean bean = (SerialBean)session.getAttribute(KEY);
        resp.setContentType("text/plain");
        if (req.getParameter("readonly") != null) {
            out.print(bean.getSerial());
            out.println(this.getContainerSpecificDebugInfo(req));
            return;
        }
        int serial = bean.getSerial();
        bean.setSerial(serial + 1);
        session.setAttribute(KEY, (Object)bean);
        Enumeration headers = req.getHeaderNames();
        while (headers.hasMoreElements()) {
            String header = (String)headers.nextElement();
            out.println("Request header: " + header + "=" + req.getHeader(header));
        }
        out.println("Request URI: " + req.getRequestURI());
        out.println("Query string: " + req.getQueryString());
        out.println("Query string UTF-8 decoded: " + (req.getQueryString() == null ? "null" : URLDecoder.decode(req.getQueryString(), StandardCharsets.UTF_8)));
        out.println("Path info: " + req.getPathInfo());
        out.println("Serial: " + serial);
        out.println("Session ID: " + req.getSession().getId());
        out.println("Current time: " + String.valueOf(new Date()));
        out.println("ServletRequest.getServerPort(): " + req.getServerPort());
        out.println("ServletRequest.getLocalPort(): " + req.getLocalPort());
        out.println("Node name: " + System.getProperty("jboss.node.name"));
        out.println("Runtime.getRuntime().availableProcessors(): " + Runtime.getRuntime().availableProcessors());
        out.println(this.printRequestParameters(req));
        out.println(this.getContainerSpecificDebugInfo(req));
        if (req.getParameter("invalidate") != null) {
            log.log(Level.INFO, "Invalidating: {0}", session.getId());
            session.invalidate();
        }
    }

    private String printRequestParameters(HttpServletRequest request) {
        StringBuilder responseText = new StringBuilder();
        responseText.append("Parameters [key=value]: {");
        Map params = request.getParameterMap();
        Iterator i = params.keySet().iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            String value = ((String[])params.get(key))[0];
            responseText.append("[");
            responseText.append(key);
            responseText.append("=");
            responseText.append(value);
            responseText.append("]");
            if (!i.hasNext()) continue;
            responseText.append(" ");
        }
        responseText.append("}");
        return responseText.toString();
    }

    public String getServletInfo() {
        return "Debug servlet.";
    }

    public abstract String getContainerSpecificDebugInfo(HttpServletRequest var1);
}

