/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.clusterbench.common.load;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.test.clusterbench.common.load.AverageSystemLoad;

public class AverageSystemLoad {
    private static final Logger log = Logger.getLogger(AverageSystemLoad.class.getName());
    private List<LoadRunner> loadRunners = new ArrayList();

    public String spawnLoadThreads(int numberOfThreads, int milliseconds) {
        long operationStarted = System.currentTimeMillis();
        for (int i = 0; i < numberOfThreads; ++i) {
            this.loadRunners.add(new LoadRunner(this, milliseconds));
        }
        while (this.stillActiveRunners() != 0) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                log.log(Level.SEVERE, "Whoops, our monitoring thread has been interrupted.");
            }
        }
        return "DONE, I was stressing CPU with " + numberOfThreads + " evil threads for " + (System.currentTimeMillis() - operationStarted) + " milliseconds (including warm-up).";
    }

    private int stillActiveRunners() {
        int stillActiveRunners = 0;
        for (LoadRunner loadRunner : this.loadRunners) {
            if (loadRunner.isComplete()) continue;
            ++stillActiveRunners;
        }
        return stillActiveRunners;
    }
}

