/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.clusterbench.web.load;

import jakarta.servlet.ServletException;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.test.clusterbench.common.load.AverageSystemLoad;

@WebServlet(name="AverageSystemLoadServlet", urlPatterns={"/averagesystemload"})
public class AverageSystemLoadServlet
extends HttpServlet {
    private static final Logger log = Logger.getLogger(AverageSystemLoadServlet.class.getName());
    private final AverageSystemLoad averageSystemLoad = new AverageSystemLoad();

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        int milliseconds = Integer.parseInt(request.getParameter("milliseconds"));
        int numberOfThreads = Integer.parseInt(request.getParameter("threads"));
        response.setContentType("text/plain");
        String resultLogMessage = this.averageSystemLoad.spawnLoadThreads(numberOfThreads, milliseconds);
        log.log(Level.INFO, resultLogMessage);
        response.getWriter().print("DONE");
    }

    public String getServletInfo() {
        return "By invoking AverageSystemLoadServlet, you stress CPU.";
    }
}

