/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.clusterbench.web.cdi;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.jboss.test.clusterbench.web.cdi.SessionScopedCdiSerialBean;

@WebServlet(name="CdiServlet", urlPatterns={"/cdi"})
public class CdiServlet
extends HttpServlet {
    @Inject
    private SessionScopedCdiSerialBean bean;
    private static final Logger log = Logger.getLogger(CdiServlet.class.getName());

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        resp.setContentType("text/plain");
        int serial = this.bean.getSerial();
        if (req.getParameter("readonly") != null) {
            resp.getWriter().print(this.bean.getSerial());
            return;
        }
        this.bean.setSerial(serial + 1);
        resp.getWriter().print(serial);
        if (req.getParameter("invalidate") != null) {
            HttpSession session = req.getSession(true);
            log.log(Level.INFO, "Invalidating: {0}", session.getId());
            session.invalidate();
        }
    }

    public String getServletInfo() {
        return "Servlet using CDI bean to store serial.";
    }
}

