/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.thread;

import junit.framework.AssertionFailedError;
import org.jboss.logging.Logger;
import org.jboss.test.AbstractTestCase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestThread
extends Thread
implements Thread.UncaughtExceptionHandler {
    private Logger log = Logger.getLogger(TestThread.class);
    private Throwable t;

    public TestThread() {
        this.setUncaughtExceptionHandler(this);
    }

    public TestThread(String name) {
        super(name);
        this.setUncaughtExceptionHandler(this);
    }

    @Override
    public void uncaughtException(Thread t, Throwable e) {
        this.log.error((Object)("Error in thread " + t), e);
        this.t = e;
    }

    public void doJoin() throws InterruptedException {
        super.join();
        if (this.t != null) {
            if (this.t instanceof AssertionFailedError) {
                throw (AssertionFailedError)this.t;
            }
            AssertionFailedError e = new AssertionFailedError("Error in thread" + this.t);
            e.initCause(this.t);
            throw e;
        }
    }

    public void doJoin(long millis) throws InterruptedException {
        super.join(millis);
        if (this.t != null) {
            if (this.t instanceof AssertionFailedError) {
                throw (AssertionFailedError)this.t;
            }
            AssertionFailedError e = new AssertionFailedError("Error in thread" + this.t);
            e.initCause(this.t);
            throw e;
        }
    }

    public void doJoinExpectError(Class<? extends Throwable> expected) throws InterruptedException {
        super.join();
        if (this.t == null) {
            throw new AssertionFailedError("No error from thread " + this);
        }
        AbstractTestCase.checkThrowable(expected, this.t);
    }

    public void doJoinExpectError(long millis, Class<? extends Throwable> expected) throws InterruptedException {
        super.join(millis);
        if (this.t == null) {
            throw new AssertionFailedError("No error from thread " + this);
        }
        AbstractTestCase.checkThrowable(expected, this.t);
    }
}

