/*
* JBoss, Home of Professional Open Source
* Copyright 2010, JBoss Inc., and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/

package org.jboss.test.jms;

import java.util.HashMap;
import java.util.Map;

import javax.management.ObjectName;

import org.jboss.util.NestedRuntimeException;

/**
 * 
 * @author <mailto:clebert.suconic@jboss.org">Clebert Suconic</a>
 *
 */
public abstract class JMSTestAdmin
{

   protected Map<String, TestRole[]> deployedTopics = new HashMap<String, TestRole[]>();
   protected Map<String, TestRole[]> deployedQueues = new HashMap<String, TestRole[]>();

   public static JMSTestAdmin admin;
   
   public static JMSTestAdmin getAdmin()
   {
      if (admin == null)
      {
         try
         {
            // TODO: make this configurable
            admin = new HornetQTestAdmin();
         }
         catch (Exception e)
         {
            e.printStackTrace(); // >> junit report
            throw new NestedRuntimeException(e.getMessage(), e);
         }
      }
      
      return admin;
   }
   
   
	/**
	 * 
	 * @param name
	 * @param securityConfig
	 * @return information about the deployment required to undeploy/remove the topic
	 * @throws Exception 
	 */
   public abstract void createTopic(String name, TestRole ... securityConfig) throws Exception;

   public abstract void createTopic(String name, String[] jndi, TestRole ... securityConfig) throws Exception;

	public abstract void deleteTopic(String topic) throws Exception;

	public abstract void createQueue(String name, TestRole ... securityConfig) throws Exception;

   public abstract void createQueue(String name, String[] jndi, TestRole ... securityConfig) throws Exception;

   public abstract void deleteQueue(String queue) throws Exception;
	
	public abstract void destroyCreatedDestinations() throws Exception;
	
	public abstract void destroyEveryDestination() throws Exception;
	
	public abstract ObjectName createQueueJMXName(String queueName);
	
	public abstract ObjectName createTopicJMXName(String queueName);
}
