/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test;

import org.jboss.test.JBossTestCase;
import org.jboss.test.jms.JMSTestAdmin;
import org.jboss.test.jms.TestRole;
import org.jboss.util.NestedRuntimeException;

public class JBossJMSTestCase
extends JBossTestCase {
    public JBossJMSTestCase(String name) {
        super(name);
    }

    protected static void deployTopic(String name, TestRole ... securityConfig) throws Exception {
        JMSTestAdmin.getAdmin().createTopic(name, securityConfig);
    }

    protected static void deployQueue(String name, TestRole ... securityConfig) throws Exception {
        JMSTestAdmin.getAdmin().createQueue(name, securityConfig);
    }

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    protected static void undeployDestinations() throws Exception {
        JMSTestAdmin.getAdmin().destroyCreatedDestinations();
    }

    protected static void undeployQueue(String queue) throws Exception {
        JMSTestAdmin.getAdmin().deleteQueue(queue);
    }

    protected static void undeployTopic(String topic) throws Exception {
        JMSTestAdmin.getAdmin().deleteTopic(topic);
    }

    public void createQueue(String name) throws Exception {
        JBossJMSTestCase.deployQueue(name, new TestRole("guest", true, true, true));
    }

    public void deleteQueue(String name) {
        try {
            JBossJMSTestCase.undeployQueue(name);
        }
        catch (Exception e) {
            throw new NestedRuntimeException("deleteQueue() operation failed", (Throwable)e);
        }
    }

    public void createTopic(String name) throws Exception {
        JBossJMSTestCase.deployTopic(name, new TestRole[0]);
    }

    public void deleteTopic(String name) throws Exception {
        JBossJMSTestCase.undeployTopic(name);
    }
}

