/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.selenium.actions;

import java.util.Iterator;
import org.apache.commons.lang.enums.EnumUtils;
import org.jboss.test.selenium.framework.AjaxSelenium;
import org.jboss.test.selenium.geometry.Point;
import org.jboss.test.selenium.locator.ElementLocator;
import org.jboss.test.selenium.waiting.Wait;
import org.jboss.test.selenium.waiting.selenium.SeleniumWaiting;

public class Drag {
    private static final int NUMBER_OF_STEPS = 5;
    private static final int FIRST_STEP = 2;
    Point point;
    private Phase currentPhase;
    private ElementLocator itemToDrag;
    private ElementLocator dropTarget;
    private int x;
    private int y;
    private final SeleniumWaiting wait = (SeleniumWaiting)Wait.waitSelenium().timeout(10L);

    public Drag(ElementLocator itemToDrag, ElementLocator dropTarget) {
        this.currentPhase = Phase.START;
        this.itemToDrag = itemToDrag;
        this.dropTarget = dropTarget;
        AjaxSelenium selenium = AjaxSelenium.getCurrentSelenium();
        this.x = selenium.getElementPositionLeft(dropTarget) - selenium.getElementPositionLeft(itemToDrag);
        this.y = selenium.getElementPositionTop(dropTarget) - selenium.getElementPositionTop(itemToDrag);
    }

    public void start() {
        this.processUntilPhase(Phase.START);
    }

    public void mouseOut() {
        this.processUntilPhase(Phase.MOUSE_OUT);
    }

    public void move() {
        this.processUntilPhase(Phase.MOVE);
    }

    public void enter() {
        this.processUntilPhase(Phase.ENTER);
    }

    public void drop() {
        this.processUntilPhase(Phase.DROP);
    }

    private void processUntilPhase(Phase request) {
        if (request.before(this.currentPhase)) {
            throw new IllegalArgumentException();
        }
        while (this.currentPhase.before(request)) {
            this.executePhase(this.currentPhase);
            this.currentPhase = this.currentPhase.next();
        }
    }

    private void executePhase(Phase phase) {
        AjaxSelenium selenium = AjaxSelenium.getCurrentSelenium();
        switch (phase) {
            case START: {
                selenium.mouseDown(this.itemToDrag);
                this.point = new Point(this.x < 0 ? 2 : -2, this.y < 0 ? 2 : -2);
                selenium.mouseMoveAt(this.itemToDrag, this.point);
                break;
            }
            case MOUSE_OUT: {
                selenium.mouseOut(this.itemToDrag);
                break;
            }
            case MOVE: {
                for (int i = 0; i < 5; ++i) {
                    this.point = new Point(this.x * i / 5, this.y * i / 5);
                    selenium.mouseMoveAt(this.itemToDrag, this.point);
                    this.wait.waitForTimeout();
                }
                break;
            }
            case ENTER: {
                this.point = new Point(this.x, this.y);
                selenium.mouseMoveAt(this.itemToDrag, this.point);
                selenium.mouseOver(this.dropTarget);
                break;
            }
            case DROP: {
                selenium.mouseUp(this.dropTarget);
                break;
            }
        }
    }

    private static enum Phase {
        START,
        MOUSE_OUT,
        MOVE,
        ENTER,
        DROP;


        boolean before(Phase phase) {
            return this.compareTo(phase) < 0;
        }

        Phase next() {
            Phase phase;
            Iterator iterator = EnumUtils.iterator(Phase.class);
            while (this != (phase = (Phase)((Object)iterator.next())) && iterator.hasNext()) {
            }
            return (Phase)((Object)iterator.next());
        }
    }
}

