/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.selenium.framework;

import com.thoughtworks.selenium.CommandProcessor;
import com.thoughtworks.selenium.HttpCommandProcessor;
import java.net.URL;
import org.jboss.test.selenium.browser.Browser;
import org.jboss.test.selenium.framework.ExtendedSelenium;
import org.jboss.test.selenium.framework.ExtendedTypedSelenium;
import org.jboss.test.selenium.framework.internal.PageExtensions;
import org.jboss.test.selenium.framework.internal.SeleniumExtensions;
import org.jboss.test.selenium.interception.InterceptionProxy;

public class AjaxSelenium
extends ExtendedTypedSelenium {
    private static final ThreadLocal<AjaxSelenium> REFERENCE = new ThreadLocal();
    PageExtensions pageExtensions;
    SeleniumExtensions seleniumExtensions;
    InterceptionProxy interceptionProxy;

    private AjaxSelenium() {
    }

    public AjaxSelenium(String serverHost, int serverPort, Browser browser, URL contextPathURL) {
        HttpCommandProcessor commandProcessor = new HttpCommandProcessor(serverHost, serverPort, browser.getAsString(), contextPathURL.toString());
        this.interceptionProxy = new InterceptionProxy((CommandProcessor)commandProcessor);
        this.selenium = new ExtendedSelenium(this.interceptionProxy.getCommandProcessorProxy());
        this.pageExtensions = new PageExtensions(this);
        this.seleniumExtensions = new SeleniumExtensions(this);
        AjaxSelenium.setCurrentSelenium(this);
    }

    public static void setCurrentSelenium(AjaxSelenium selenium) {
        REFERENCE.set(selenium);
    }

    public static AjaxSelenium getCurrentSelenium() {
        return REFERENCE.get();
    }

    public PageExtensions getPageExtensions() {
        return this.pageExtensions;
    }

    public SeleniumExtensions getSeleniumExtensions() {
        return this.seleniumExtensions;
    }

    public InterceptionProxy getInterceptionProxy() {
        return this.interceptionProxy;
    }

    public AjaxSelenium immutableCopy() {
        AjaxSelenium copy = new AjaxSelenium();
        copy.pageExtensions = new PageExtensions(copy);
        copy.seleniumExtensions = new SeleniumExtensions(copy);
        copy.interceptionProxy = this.interceptionProxy.immutableCopy();
        copy.selenium = new ExtendedSelenium(copy.interceptionProxy.getCommandProcessorProxy());
        return copy;
    }
}

