/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.selenium.guard.request;

import com.thoughtworks.selenium.SeleniumException;
import org.jboss.test.selenium.encapsulated.JavaScript;
import org.jboss.test.selenium.framework.AjaxSelenium;
import org.jboss.test.selenium.guard.GuardedCommands;
import org.jboss.test.selenium.guard.request.RequestGuardException;
import org.jboss.test.selenium.guard.request.RequestType;
import org.jboss.test.selenium.interception.CommandContext;
import org.jboss.test.selenium.interception.CommandInterceptionException;
import org.jboss.test.selenium.interception.CommandInterceptor;
import org.jboss.test.selenium.utils.text.SimplifiedFormat;

public class RequestTypeGuard
implements CommandInterceptor {
    private final JavaScript clearRequestDone = JavaScript.js("getRFS().clearRequestDone()");
    private final JavaScript getRequestDone = JavaScript.js("(getRFS() === undefined) ? 'HTTP' : getRFS().getRequestDone()");
    private final JavaScript waitRequestChange = JavaScript.js("((getRFS() === undefined) ? 'HTTP' : getRFS().getRequestDone()) != 'NONE' && selenium.browserbot.getCurrentWindow().document.body");
    private RequestType requestExpected;

    public RequestTypeGuard(RequestType requestExpected) {
        this.requestExpected = requestExpected;
    }

    @Override
    public void intercept(CommandContext ctx) throws CommandInterceptionException {
        String command = ctx.getCommand();
        if (GuardedCommands.INTERACTIVE_COMMANDS.contains(command)) {
            this.doBeforeCommand();
        }
        ctx.doCommand();
        if (GuardedCommands.INTERACTIVE_COMMANDS.contains(command)) {
            this.doAfterCommand();
        }
    }

    public void doBeforeCommand() {
        AjaxSelenium.getCurrentSelenium().getPageExtensions().install();
        AjaxSelenium.getCurrentSelenium().getEval(this.clearRequestDone);
    }

    public void doAfterCommand() {
        try {
            AjaxSelenium.getCurrentSelenium().waitForCondition(this.waitRequestChange, 30000L);
        }
        catch (SeleniumException e) {
            // empty catch block
        }
        RequestType requestDone = this.getRequestDone();
        if (requestDone != this.requestExpected) {
            throw new RequestGuardException(this.requestExpected, requestDone);
        }
    }

    private RequestType getRequestDone() {
        String requestDone = AjaxSelenium.getCurrentSelenium().getEval(this.getRequestDone);
        try {
            return RequestType.valueOf(requestDone);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalStateException(SimplifiedFormat.format("Request was evaluated to unknown type", requestDone));
        }
    }
}

