/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.selenium.listener;

import java.util.Date;
import org.jboss.test.selenium.utils.testng.TestInfo;
import org.testng.ITestResult;
import org.testng.TestListenerAdapter;

public class ConsoleStatusTestListener
extends TestListenerAdapter {
    public void onTestStart(ITestResult result) {
        this.logStatus(result);
    }

    public void onTestFailure(ITestResult result) {
        this.logStatus(result);
    }

    public void onTestSkipped(ITestResult result) {
        this.logStatus(result);
    }

    public void onTestSuccess(ITestResult result) {
        this.logStatus(result);
    }

    public void onTestFailedButWithinSuccessPercentage(ITestResult result) {
        this.logStatus(result);
    }

    private void logStatus(ITestResult result) {
        String methodName = TestInfo.getMethodName(result);
        String status = TestInfo.STATUSES.get(result.getStatus());
        StringBuilder parameters = new StringBuilder("(");
        if (result.getParameters() != null && result.getParameters().length != 0) {
            parameters.append("\"");
            parameters.append(result.getParameters()[0]);
            parameters.append("\"");
        }
        parameters.append(")");
        String message = String.format("[%tT] %s: %s%s", new Date(), status.toUpperCase(), methodName, parameters.toString());
        System.out.println(message);
    }
}

